/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package urednik;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;

/**
 *
 * @author Stefan
 */
public class Main {

    @Resource(lookup = "MyQueue")
    static Queue queue;
    @Resource(lookup = "MyTopic")
    static Topic topic;
    @Resource(lookup = "jms/__defaultConnectionFactory")
    static ConnectionFactory connectionFactory;
    
    public static void main(String[] args) {
        JMSContext context = connectionFactory.createContext();
        JMSProducer producer = context.createProducer();
        
        int tipPoruke;
        int i = 0;
        while(true){
            try {
                i++;
                TextMessage textMessage = context.createTextMessage();
                textMessage.setText("Vest " + i);
                
                tipPoruke = (int)(Math.random() * 3);
                
                String tip = null;
                switch(tipPoruke){
                    case 0:
                        tip = "OBAVESTENJE";
                        break;
                    case 1:
                        tip = "STANDARDNO";
                        break;
                    case 2:
                        tip = "BITNO";
                        break;
                }
                textMessage.setStringProperty("Tip", tip);
                
                producer.send(topic, textMessage);
                System.out.println("Poslata je vest: " + textMessage.getText() + ", tip vesti: " + tip);
                Thread.sleep(5000);
                
            } catch (JMSException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            } catch (InterruptedException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            
        }
    }
    
}
