/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package prikupljacvesti;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jms.ConnectionFactory;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;

/**
 *
 * @author Stefan
 */
public class Main {

    @Resource(lookup = "MyQueue")
    static Queue queue;
    @Resource(lookup = "MyTopic")
    static Topic topic;
    @Resource(lookup = "jms/__defaultConnectionFactory")
    static ConnectionFactory connectionFactory;
    
    static int id = 0;
    static String idString = "Id" + id;
    
    public static void main(String[] args) {
        JMSContext context =  connectionFactory.createContext();
        
        String tip = null;
        switch(id){
            case 0:
                tip = "OBAVESTENJE";
                break;
            case 1:
                tip = "STANDARDNO";
                break;
            case 2:
                tip = "BITNO";
                break;
        }
        
        context.setClientID(idString);
        JMSConsumer consumer = context.createDurableConsumer(topic, idString, "Tip = '" + tip + "'", false);
        
        while(true){
            Message message = consumer.receive();
            try {
                TextMessage textMessage = (TextMessage) message;
                System.out.println("Procitana je vest: " + textMessage.getText() + ", tip: " + textMessage.getStringProperty("Tip"));
            } catch (JMSException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
    
}
