using System;
using System.Collections.Generic;
using System.Text.Json.Serialization;
using Microsoft.EntityFrameworkCore;

/*
Ukoliko postoji greska prilikom serijalizacije odgovora jedan nacin da se to resi jeste dodavanjem JsonIgnore
atributa na reference u entiteskim klasama. Drugi nacin jeste dodavanjem paketa Microsoft.AspNetCore.Mvc.NewtonsoftJson
i dodatnim podesavanjem u ConfigureServices metodi Startup klase. 
*/
namespace Model {
    public class User {
        public int id { get; set; }
        public string firstName { get; set; }
        public string lastName { get; set; }
        public string email { get; set; }
        public string gender { get; set; }
        public string username { get; set; }
        public string password { get; set; }
        public ICollection<Action> actionList { get; set; }
        public ICollection<HasRole> hasRoleList { get; set; }
        public override string ToString ( ) {
            return "User(" + this.id + "): " + this.firstName + ", " + this.lastName + ", " + this.email + ", " + this.gender + ", " + this.username + ", " + this.password; 
        } 
    }

    public class Role {
        public int id { get; set; }
        public string name { get; set; }
        // [JsonIgnore]
        public ICollection<HasRole> hasRoleList { get; set; }

        public override string ToString ( ) {
            return "Role(" + this.id + "): " + this.name;
        }
    }

    public class HasRole {
        public int userId { get; set; }
        // [JsonIgnore]
        public User user { get; set; }
        public int roleId { get; set; }
        // [JsonIgnore]
        public Role role { get; set; }

        public override string ToString ( ) {
            return "HasRole(" + this.userId + ", " + this.roleId + ")";
        }
    }

    public class Action {
        public int id { get; set; }
        public int userId  { get; set; }
        // [JsonIgnore]
        public User user { get; set; }
        public string name { get; set; }
        public DateTime timestamp { get; set; }

        public override string ToString ( ) {
            return "Action(" + this.id + "): " + this.userId + ", " + this.name + ", " + this.timestamp;
        }
    }


    public class Context : DbContext {
        public DbSet<User> users { get; set; }
        public DbSet<Role> roles { get; set; }
        public DbSet<HasRole> hasRole { get; set; }
        public DbSet<Action> actions { get; set; }

        /*
        Ovakav konstruktor omogucava da izvrsno okruzenje instancira objekte klase izvedene iz klase
        DbContext sto omogucava da kontroleri primaju objekat ove klase kao parametar konstruktora.
        */
        public Context ( DbContextOptions builder ) : base ( builder ) { }

        protected override void OnModelCreating ( ModelBuilder builder ) {
            builder.Entity<HasRole> ( ).HasKey ( hasRole => new { hasRole.userId, hasRole.roleId } );
        }
    }
}