import secrets

from web3 import Web3
from web3 import HTTPProvider
from web3 import Account
from web3.exceptions import ContractLogicError

TOKEN_PRICE = 300000

web3 = Web3 ( HTTPProvider ( "http://127.0.0.1:8545" ) )


def create_and_initialize_account ( ):
    # create account
    private_key = "0x" + secrets.token_hex ( 32 )
    account     = Account.from_key ( private_key )
    address     = account.address

    # send funds from account 0
    result = web3.eth.send_transaction ({
        "from": web3.eth.accounts[0],
        "to": address,
        "value": web3.to_wei ( 2, "ether" ),
        "gasPrice": 1
    })

    return ( address, private_key )

def send_transaction ( transaction, private_key ):
    signed_transaction = web3.eth.account.sign_transaction ( transaction, private_key )
    transaction_hash   = web3.eth.send_raw_transaction ( signed_transaction.raw_transaction )
    receipt            = web3.eth.wait_for_transaction_receipt ( transaction_hash )

    return receipt

def read_file ( path ):
    with open ( path, "r" ) as file:
        return file.read ( )

### install solc compiler
# import solcx
# solcx.install_solc ( SOLC_VERSION )
#
# SOLC_VERSION  = "0.8.18"
# CONTRACT_PATH = "./solidity/tokens.sol"
# 
# compile_result = solcx.compile_source ( 
#     read_file ( CONTRACT_PATH ),
#     output_values = ["abi", "bin-runtime"],
#     solc_version = SOLC_VERSION 
# )
# 
# key = list ( compile_result.keys ( ) )[0]
# 
# abi      = compile_result[key]["abi"]
# bytecode = compile_result[key]["bin-runtime"]

abi      =  read_file ( "./solidity/output/Tokens.abi" )
bytecode =  read_file ( "./solidity/output/Tokens.bin" )

shop_owner_address, shop_owner_private_key = create_and_initialize_account ( )
customer0_address , customer0_private_key  = create_and_initialize_account ( )
customer1_address , customer1_private_key  = create_and_initialize_account ( )

shop_owner_balance = web3.eth.get_balance ( shop_owner_address )
customer0_balance  = web3.eth.get_balance ( customer0_address )
customer1_balance  = web3.eth.get_balance ( customer1_address )

print ( f"SHOP OWNER ( ADDRESS = {shop_owner_address}, PRIVATE KEY = {shop_owner_private_key}, BALANCE = {shop_owner_balance} )")
print ( f"CUSTOMER 0 ( ADDRESS = {customer0_address}, PRIVATE KEY = {customer0_private_key}, BALANCE = {customer0_balance} )")
print ( f"CUSTOMER 1 ( ADDRESS = {customer1_address}, PRIVATE KEY = {customer1_private_key}, BALANCE = {customer1_balance} )")


# create contract
contract_creation_transaction = web3.eth.contract ( bytecode = bytecode, abi = abi )\
    .constructor ( TOKEN_PRICE ).build_transaction ({
    "from": shop_owner_address,
    "nonce": web3.eth.get_transaction_count ( shop_owner_address ),
    "gasPrice": 1
})

result = send_transaction ( contract_creation_transaction, shop_owner_private_key )
contract_address = result["contractAddress"]
print ( f"CONTRACT CREATED: {contract_address}" )

# buy tokens for customers
CUSTOMER0_TOKEN_AMOUNT = 10
CUSTOMER1_TOKEN_AMOUNT = 15

contract = web3.eth.contract ( address = contract_address, abi = abi )

customer0_token_buy_transaction = contract.functions.buy_tokens ( CUSTOMER0_TOKEN_AMOUNT ).build_transaction({
    "from": customer0_address,
    "value": TOKEN_PRICE * CUSTOMER0_TOKEN_AMOUNT,
    "nonce": web3.eth.get_transaction_count ( customer0_address ),
    "gasPrice": 1
})

send_transaction ( customer0_token_buy_transaction, customer0_private_key )

customer1_token_buy_transaction = contract.functions.buy_tokens ( CUSTOMER1_TOKEN_AMOUNT ).build_transaction({
    "from": customer1_address,
    "value": TOKEN_PRICE * CUSTOMER1_TOKEN_AMOUNT,
    "nonce": web3.eth.get_transaction_count ( customer1_address ),
    "gasPrice": 1
})

send_transaction ( customer1_token_buy_transaction, customer1_private_key )

customer0_token_balance = contract.functions.get_balance ( customer0_address ).call ( )
customer1_token_balance = contract.functions.get_balance ( customer1_address ).call ( )

print ( f"CUSTOMER0 TOKEN BALANCE = {customer0_token_balance}" )
print ( f"CUSTOMER1 TOKEN BALANCE = {customer1_token_balance}" )

# spend customer tokens
print ( f"CUSTOMER0 SPENT AMOUNT = {CUSTOMER0_TOKEN_AMOUNT // 2} " )
print ( f"CUSTOMER1 SPENT AMOUNT = {CUSTOMER1_TOKEN_AMOUNT // 2} " )

customer0_spend_tokens_transaction = contract.functions.spend_tokens ( customer0_address, CUSTOMER0_TOKEN_AMOUNT // 2 ).build_transaction ({
    "from": customer0_address,
    "nonce": web3.eth.get_transaction_count ( customer0_address ),
    "gasPrice": 1
})

send_transaction ( customer0_spend_tokens_transaction, customer0_private_key )

customer1_spend_tokens_transaction = contract.functions.spend_tokens ( customer1_address, CUSTOMER1_TOKEN_AMOUNT // 2 ).build_transaction ({
    "from": customer1_address,
    "nonce": web3.eth.get_transaction_count ( customer1_address ),
    "gasPrice": 1
})

send_transaction ( customer1_spend_tokens_transaction, customer1_private_key )

customer0_token_balance = contract.functions.get_balance ( customer0_address ).call ( )
customer1_token_balance = contract.functions.get_balance ( customer1_address ).call ( )

print ( f"CUSTOMER0 TOKEN BALANCE = {customer0_token_balance}" )
print ( f"CUSTOMER1 TOKEN BALANCE = {customer1_token_balance}" )

# withdraw funds from contract 

shop_owner_balance = web3.eth.get_balance ( shop_owner_address )
customer0_balance  = web3.eth.get_balance ( customer0_address )
customer1_balance  = web3.eth.get_balance ( customer1_address )

print ( f"SHOP OWNER ( ADDRESS = {shop_owner_address}, PRIVATE KEY = {shop_owner_private_key}, BALANCE = {shop_owner_balance} )")
print ( f"CUSTOMER 0 ( ADDRESS = {customer0_address}, PRIVATE KEY = {customer0_private_key}, BALANCE = {customer0_balance} )")
print ( f"CUSTOMER 1 ( ADDRESS = {customer1_address}, PRIVATE KEY = {customer1_private_key}, BALANCE = {customer1_balance} )")

withdraw_transaction = contract.functions.withdraw ( ).build_transaction({
    "from": shop_owner_address,
    "nonce": web3.eth.get_transaction_count ( shop_owner_address ),
    "gasPrice": 1
})

send_transaction ( withdraw_transaction, shop_owner_private_key )

shop_owner_balance = web3.eth.get_balance ( shop_owner_address )

print ( f"SHOP OWNER ( ADDRESS = {shop_owner_address}, PRIVATE KEY = {shop_owner_private_key}, BALANCE = {shop_owner_balance} )")

# error handling
customer0_spend_tokens_transaction = contract.functions.spend_tokens ( customer0_address, 2 * CUSTOMER0_TOKEN_AMOUNT ).build_transaction ({
    "from": customer0_address,
    "nonce": web3.eth.get_transaction_count ( customer0_address ),
    "gasPrice": 1
})

try:
    send_transaction ( customer0_spend_tokens_transaction, customer0_private_key )
except ContractLogicError as error:
    print ( error )