from web3 import Web3
from web3 import HTTPProvider
from web3 import Account
from web3.exceptions import ContractLogicError
from web3.exceptions import ContractCustomError

import secrets
import threading
import random

web3 = Web3 ( HTTPProvider ( "http://127.0.0.1:8545" ) )

def create_and_initialize_account ( ):
    # create account
    private_key = "0x" + secrets.token_hex ( 32 )
    account     = Account.from_key ( private_key )
    address     = account.address

    # send funds from account 0
    result = web3.eth.send_transaction ({
        "from": web3.eth.accounts[0],
        "to": address,
        "value": web3.to_wei ( 2, "ether" ),
        "gasPrice": 1
    })

    return ( address, private_key )

def send_transaction ( transaction, private_key ):
    signed_transaction = web3.eth.account.sign_transaction ( transaction, private_key )
    transaction_hash   = web3.eth.send_raw_transaction ( signed_transaction.raw_transaction )
    receipt            = web3.eth.wait_for_transaction_receipt ( transaction_hash )

    return receipt

def read_file ( path ):
    with open ( path, "r" ) as file:
        return file.read ( )

bytecode = read_file ( "./solidity/output/TicTacToe.bin" )
abi      = read_file ( "./solidity/output/TicTacToe.abi" )

contract = web3.eth.contract ( bytecode = bytecode, abi = abi )

x_player_address, x_player_private_key = create_and_initialize_account ( )
o_player_address, o_player_private_key = create_and_initialize_account ( )
intruder_address, intruder_private_key = create_and_initialize_account ( )

create_contract_transaction = contract.constructor ( "XPlayer" ).build_transaction ({
    "from": x_player_address,
    "value": 100,
    "nonce": web3.eth.get_transaction_count ( x_player_address ),
    "gasPrice": 1
})

receipt = send_transaction ( create_contract_transaction, x_player_private_key )

contract = web3.eth.contract ( address = receipt.contractAddress, abi = abi )

def event_loop ( event_filter, poll_interval, stopped ):
    while ( not stopped ( ) ):
        for event in event_filter.get_new_entries ( ):
            print ( event )

        # time.sleep ( poll_interval )

stop    = False
stopped = lambda: stop

o_joined_event_filter      = contract.events.OJoined.create_filter ( fromBlock = "latest" )
move_event_filter          = contract.events.Move.create_filter ( fromBlock = "latest" )
game_finished_event_filter = contract.events.GameFinished.create_filter ( fromBlock = "latest" )

o_joined_thread = threading.Thread ( 
    target = event_loop, 
    args = ( o_joined_event_filter, 1, stopped ) 
)

move_thread = threading.Thread ( 
    target = event_loop, 
    args = ( move_event_filter, 1, stopped ) 
)

game_finished_thread = threading.Thread ( 
    target = event_loop, 
    args = ( game_finished_event_filter, 1, stopped ) 
)

o_joined_thread.start ( );
move_thread.start ( )
game_finished_thread.start ( )


x_player_name = contract.functions.get_x_player_name ( ).call ( )
wager         = contract.functions.get_wager ( ).call ( )
state         = contract.functions.get_state ( ).call ( )

print ( f"X PLAYER NAME: {x_player_name}" )
print ( f"WAGER: {wager}" )
print ( f"STATE: {state}" )

o_join_transaction = contract.functions.join_o ( "OPlayer" ).build_transaction ({
    "from": o_player_address,
    "value": 100,
    "nonce": web3.eth.get_transaction_count ( o_player_address ),
    "gasPrice": 1
})

send_transaction ( o_join_transaction, o_player_private_key )

game_over = False

def print_board ( board ):
    symbols = [" ", "X", "0"]
    
    symbol_board = [symbols[item] for item in board]

    for row in range ( 3 ):
        for column in range ( 3 ):
            if ( column != 0 ):
                print ( "|", end = "" )
            index = row * 3 + column
            print ( symbol_board[index], end = "" )

        print ( )
        if ( row != 2 ):
            print ( "-----" )
         
    print ( "====================" )

while ( not game_over ):
    board = contract.functions.get_board ( ).call ( )
    print_board ( board )

    free_slots = [
        (index // 3, index % 3) 
        for index, value in enumerate ( board ) 
        if ( value == 0 )
    ]

    slot = random.choice ( free_slots )

    print ( slot )
    try:
        x_move_transaction = contract.functions.play ( slot[0], slot[1] ).build_transaction ({
            "from": x_player_address,
            "nonce": web3.eth.get_transaction_count ( x_player_address ),
            "gasPrice": 1
        })
        send_transaction ( x_move_transaction, x_player_private_key )
    except ContractLogicError as error: 
        print ( error )

    try:
        o_move_transaction = contract.functions.play ( slot[0], slot[1] ).build_transaction ({
            "from": o_player_address,
            "nonce": web3.eth.get_transaction_count ( o_player_address ),
            "gasPrice": 1
        })
        send_transaction ( o_move_transaction, o_player_private_key )
    except ContractLogicError as error: 
        print ( error )

    game_over = contract.functions.get_state ( ).call ( ) == 2

board = contract.functions.get_board ( ).call ( )
print_board ( board )

stop = True

o_joined_thread.join ( )
move_thread.join ( )
game_finished_thread.join ( )


try:
    print ( "Intruder withdrawing wager" )
    intruder_withdraw_transaction = contract.functions.withdraw ( ).build_transaction ({
        "from": intruder_address, 
        "nonce": web3.eth.get_transaction_count ( intruder_address ),
        "gasPrice": 1
    })
    send_transaction ( intruder_withdraw_transaction, intruder_private_key )
except ContractLogicError as error:
    print ( error )

try:
    print ( "X withdrawing wager" )
    x_player_withdraw_transaction = contract.functions.withdraw ( ).build_transaction ({
        "from": x_player_address, 
        "nonce": web3.eth.get_transaction_count ( x_player_address ),
        "gasPrice": 1
    })
    send_transaction ( x_player_withdraw_transaction, x_player_private_key )
except ContractLogicError as error:
    print ( error )

try:
    print ( "O withdrawing wager" )
    o_player_withdraw_transaction = contract.functions.withdraw ( ).build_transaction ({
        "from": o_player_address, 
        "nonce": web3.eth.get_transaction_count ( o_player_address ),
        "gasPrice": 1
    })
    send_transaction ( o_player_withdraw_transaction, o_player_private_key )
except ContractLogicError as error:
    print ( error )


