pragma solidity ^0.8.18;

contract FamilyWalletSimple {
    address payable father;
    address payable mother;
    address payable child;

    uint256 available_amount;

    enum Status {
        PENDING,
        APPROVED,
        DENIED
    }

    struct Request {
        uint256 amount;
        address payable creator;
        Status status;
    }

    Request request;

    modifier only_family ( ) {
        require ( 
            msg.sender == father || msg.sender == mother || msg.sender == child, 
            "Only family members can access this account!" 
        );
        _;
    }

    constructor ( address payable _father, address payable _mother, address payable _child ) {
        father = _father;
        mother = _mother;
        child  = _child;

        request.status = Status.APPROVED;
    }

    function deposit ( ) external payable only_family {
        available_amount += msg.value;
    }

    function get_balance ( ) external view only_family returns ( uint256 ) {
        return available_amount;
    }

    function create_request ( uint256 amount ) external payable only_family {
        require ( request.status != Status.PENDING, "There is a pending request!" );
        require ( amount <= available_amount, "Insufficient funds!" );

        request.amount  = amount;
        request.creator = payable ( msg.sender );
        request.status  = Status.PENDING;

        available_amount -= amount;
    }

    function get_request ( ) external view only_family returns ( uint256, Status, address ) {
        return ( request.amount, request.status, request.creator );
    }

    function approve_request ( ) external payable only_family {
        require ( request.status == Status.PENDING, "There is no pending requests!" );
        require ( msg.sender != child, "Child cannot approve requests!" );
        require ( request.creator != msg.sender, "You cannot approve your own request!" );

        request.creator.transfer ( request.amount );
    
        request.status = Status.APPROVED;
    }

    function deny_request ( ) external only_family {
        require ( request.status == Status.PENDING, "There is no pending requests!" );
        require ( msg.sender != child, "Child cannot deny requests!" );
        require ( request.creator != msg.sender, "You cannot deny your own request!" );

        available_amount += request.amount;

        request.status = Status.DENIED;
    }
}