pragma solidity ^0.8.18;

contract Auction {
    address payable owner;
    string description;
    uint auction_end;

    address highest_bidder;
    uint highest_bid;

    mapping ( address => uint ) pending_returns;

    // error CustomError ( );

    modifier only_owner ( ) {
        require ( msg.sender == owner, "Only owner can execute this transaction!" );
        _;
    }

    modifier not_after ( uint time ) {
        require ( block.timestamp < time, "Auction has ended." );
        _;
    }

    modifier not_before ( uint time ) {
        require ( block.timestamp > time, "Auction is ongoing." );
        _;
    }

    event HighestBidIncreased ( address bidder, uint amount );
    event AuctionEnd ( address winner, uint amount );

    constructor ( string memory _description, uint _duration_in_seconds ) {
        owner       = payable ( msg.sender );
        auction_end = block.timestamp + _duration_in_seconds;
        highest_bid = 0;
        description = _description;
    }

    function get_highest_bid ( ) external view returns ( uint ) {
        return highest_bid;
    }

    function bid ( ) external payable not_after ( auction_end ) {
        require ( msg.value > highest_bid, "Bid not high enough." );

        if ( highest_bidder != address ( 0 ) ) {
            if ( pending_returns[highest_bidder] != 0 ) {
                pending_returns[highest_bidder] += highest_bid;
            } else {
                pending_returns[highest_bidder] = highest_bid;
            }
        }

        highest_bidder = msg.sender;
        highest_bid    = msg.value;

        emit HighestBidIncreased ( msg.sender, msg.value );
    }

    function end ( ) external not_before ( auction_end ) only_owner {
        // if ( msg.sender != owner ) {
        //     revert CustomError ( );
        // }

        owner.transfer ( highest_bid );
    
        emit AuctionEnd ( highest_bidder, highest_bid );
    }

    function withdraw ( ) external not_before ( auction_end ) {
        uint amount = pending_returns[msg.sender];
        if ( amount > 0 ) {
            payable ( msg.sender ).transfer ( amount );

            pending_returns[msg.sender] = 0;
        }
    }
}
