import secrets
import threading
import random

from web3 import Web3
from web3 import HTTPProvider
from web3 import Account
from web3.exceptions import ContractLogicError

web3 = Web3 ( HTTPProvider ( "http://127.0.0.1:8545" ) )

NUMBER_OF_OWNERS = 10

def create_and_initialize_account ( ):
    # create account
    private_key = "0x" + secrets.token_hex ( 32 )
    account     = Account.from_key ( private_key )
    address     = account.address

    # send funds from account 0
    result = web3.eth.send_transaction ({
        "from": web3.eth.accounts[0],
        "to": address,
        "value": web3.to_wei ( 2, "ether" ),
        "gasPrice": 1
    })

    return ( address, private_key )

def send_transaction ( transaction, private_key ):
    signed_transaction = web3.eth.account.sign_transaction ( transaction, private_key )
    transaction_hash   = web3.eth.send_raw_transaction ( signed_transaction.raw_transaction )
    receipt            = web3.eth.wait_for_transaction_receipt ( transaction_hash )

    return receipt

def read_file ( path ):
    with open ( path, "r" ) as file:
        return file.read ( )


def event_loop ( event_filter, poll_interval, stopped ):
    while ( not stopped ( ) ):
        for event in event_filter.get_new_entries ( ):
            print ( event )

        # time.sleep ( poll_interval )

stop    = False
stopped = lambda: stop

abi      =  read_file ( "./solidity/output/MultiSignatureWallet.abi" )
bytecode =  read_file ( "./solidity/output/MultiSignatureWallet.bin" )

owners = [create_and_initialize_account ( ) for i in range ( NUMBER_OF_OWNERS )]

addresses = [owner[0] for owner in owners]

contract_creation_transaction = web3.eth.contract ( bytecode = bytecode, abi = abi )\
    .constructor ( addresses, NUMBER_OF_OWNERS // 2  ).build_transaction ({
    "from": owners[0][0],
    "nonce": web3.eth.get_transaction_count ( owners[0][0] ),
    "gasPrice": 1
})

result = send_transaction ( contract_creation_transaction, owners[0][1] )
contract_address = result["contractAddress"]

contract = web3.eth.contract ( address = contract_address, abi = abi )

event_filters = [
    contract.events.Deposit.create_filter ( fromBlock = "latest" ),
    contract.events.SubmitTransaction.create_filter ( fromBlock = "latest" ),
    contract.events.ConfirmTransaction.create_filter ( fromBlock = "latest" ),
    contract.events.RevokeTransaction.create_filter ( fromBlock = "latest" ),
    contract.events.ExecuteTransaction.create_filter ( fromBlock = "latest" ),
]

threads = [
    threading.Thread ( 
        target = event_loop, 
        args = ( event_filter, 1, stopped ) 
    )
    for event_filter in event_filters
]

for thread in threads:
    thread.start ( );

for owner in owners:
    address     = owner[0]
    private_key = owner[1]

    deposit_transaction = contract.functions.deposit ( ).build_transaction ({
        "from": address,
        "value": 500,
        "nonce": web3.eth.get_transaction_count ( address ),
        "gasPrice": 1
    })
    send_transaction ( deposit_transaction, private_key )

submit_transaction = contract.functions.submit_transaction ( owners[0][0], 1000 ).build_transaction ({
    "from": owners[0][0],
    "nonce": web3.eth.get_transaction_count ( owners[0][0] ),
    "gasPrice": 1
})
send_transaction ( submit_transaction, owners[0][1] )

approvals = 0
for owner in owners[1:]:
    address     = owner[0]
    private_key = owner[1]

    if ( random.random ( ) > 0.4 ):
        confirm_transaction = contract.functions.confirm_transaction ( 0 ).build_transaction ({
            "from": address,
            "nonce": web3.eth.get_transaction_count ( address ),
            "gasPrice": 1
        })
        send_transaction ( confirm_transaction, private_key )

        approvals += 1

if ( approvals >= NUMBER_OF_OWNERS // 2 ):
    execute_transaction = contract.functions.execute_transaction ( 0 ).build_transaction ({
        "from": owners[0][0],
        "nonce": web3.eth.get_transaction_count ( owners[0][0] ),
        "gasPrice": 1
    })
    send_transaction ( execute_transaction, owners[0][1] )
else:
    revoke_transaction = contract.functions.revoke_transaction ( 0 ).build_transaction ({
        "from": owners[0][0],
        "nonce": web3.eth.get_transaction_count ( owners[0][0] ),
        "gasPrice": 1
    })
    send_transaction ( revoke_transaction, owners[0][1] )
    
stop = True
for thread in threads:
    thread.join ( );