import secrets

from web3 import Web3
from web3 import HTTPProvider
from web3 import Account
from web3.exceptions import ContractLogicError

TOKEN_PRICE = 300000

web3 = Web3 ( HTTPProvider ( "http://127.0.0.1:8545" ) )

def create_and_initialize_account ( ):
    # create account
    private_key = "0x" + secrets.token_hex ( 32 )
    account     = Account.from_key ( private_key )
    address     = account.address

    # send funds from account 0
    result = web3.eth.send_transaction ({
        "from": web3.eth.accounts[0],
        "to": address,
        "value": web3.to_wei ( 2, "ether" ),
        "gasPrice": 1
    })

    return ( address, private_key )

def send_transaction ( transaction, private_key ):
    signed_transaction = web3.eth.account.sign_transaction ( transaction, private_key )
    transaction_hash   = web3.eth.send_raw_transaction ( signed_transaction.raw_transaction )
    receipt            = web3.eth.wait_for_transaction_receipt ( transaction_hash )

    return receipt

def read_file ( path ):
    with open ( path, "r" ) as file:
        return file.read ( )

def get_request_index ( contract ):
    for event in contract.events.NewRequest.create_filter ( fromBlock = "latest" ).get_all_entries ( ):
        return event["args"]["index"]

    return 0

### install solc compiler
# import solcx
# solcx.install_solc ( SOLC_VERSION )
#
# SOLC_VERSION  = "0.8.18"
# CONTRACT_PATH = "./solidity/tokens.sol"
# 
# compile_result = solcx.compile_source ( 
#     read_file ( CONTRACT_PATH ),
#     output_values = ["abi", "bin-runtime"],
#     solc_version = SOLC_VERSION 
# )
# 
# key = list ( compile_result.keys ( ) )[0]
# 
# abi      = compile_result[key]["abi"]
# bytecode = compile_result[key]["bin-runtime"]

abi      =  read_file ( "./solidity/output/FamilyWalletAdvanced.abi" )
bytecode =  read_file ( "./solidity/output/FamilyWalletAdvanced.bin" )

banker_address, banker_private_key  = create_and_initialize_account ( )
father_address, father_private_key  = create_and_initialize_account ( )
mother_address , mother_private_key = create_and_initialize_account ( )
child_address , child_private_key   = create_and_initialize_account ( )

father_balance = web3.eth.get_balance ( father_address )
mother_balance = web3.eth.get_balance ( mother_address )
child_balance  = web3.eth.get_balance ( child_address )

print ( f"FATHER  ( ADDRESS = {father_address}, PRIVATE KEY = {father_private_key}, BALANCE = {father_balance} )" )
print ( f"MOTHER ( ADDRESS = {mother_address}, PRIVATE KEY = {mother_private_key}, BALANCE = {mother_balance} )" )
print ( f"CHILD ( ADDRESS = {child_address}, PRIVATE KEY = {child_private_key}, BALANCE = {child_balance} )" )

# create contract
contract_creation_transaction = web3.eth.contract ( bytecode = bytecode, abi = abi )\
    .constructor ( father_address, mother_address, child_address ).build_transaction ({
    "from": banker_address,
    "nonce": web3.eth.get_transaction_count ( banker_address ),
    "gasPrice": 1
})

result = send_transaction ( contract_creation_transaction, banker_private_key )
contract_address = result["contractAddress"]

print ( f"CONTRACT CREATED: {contract_address}" )

contract = web3.eth.contract ( address = contract_address, abi = abi )

# make deposits 
DEPOSIT_AMOUNT = 500

print ( f"DEPOSITING {DEPOSIT_AMOUNT} FROM ALL THREE ACCOUNTS" )

father_deposit_transaction = contract.functions.deposit ( ).build_transaction({
    "from": father_address,
    "value": DEPOSIT_AMOUNT,
    "nonce": web3.eth.get_transaction_count ( father_address ),
    "gasPrice": 1
})

mother_deposit_transaction = contract.functions.deposit ( ).build_transaction({
    "from": mother_address,
    "value": DEPOSIT_AMOUNT,
    "nonce": web3.eth.get_transaction_count ( mother_address ),
    "gasPrice": 1
})

child_deposit_transaction = contract.functions.deposit ( ).build_transaction({
    "from": child_address,
    "value": DEPOSIT_AMOUNT,
    "nonce": web3.eth.get_transaction_count ( child_address ),
    "gasPrice": 1
})

send_transaction ( father_deposit_transaction, father_private_key )
send_transaction ( mother_deposit_transaction, mother_private_key )
send_transaction ( child_deposit_transaction, child_private_key )

father_balance = web3.eth.get_balance ( father_address )
mother_balance = web3.eth.get_balance ( mother_address )
child_balance  = web3.eth.get_balance ( child_address )

print ( f"FATHER ( BALANCE = {father_balance} )" )
print ( f"MOTHER ( BALANCE = {mother_balance} )" )
print ( f"CHILD ( BALANCE = {child_balance} )" )

account_balance = contract.functions.get_balance ( ).call ({
    "from": father_address
})

print ( f"ACCOUNT ( BALANCE = {account_balance} )" )

# child requests
CHILD_REQUEST_AMOUNT = 300

child_create_request_transaction0 = contract.functions.create_request ( CHILD_REQUEST_AMOUNT ).build_transaction ({
    "from": child_address,
    "nonce": web3.eth.get_transaction_count ( child_address ),
    "gasPrice": 1
})

send_transaction ( child_create_request_transaction0, child_private_key )

account_balance = contract.functions.get_balance ( ).call ({
    "from": child_address
})

print ( f"ACCOUNT ( BALANCE = {account_balance} )" )

child_request_index0 = get_request_index ( contract )

request0 = contract.functions.get_request ( child_request_index0 ).call ({
    "from": child_address
})

print ( f"REQUEST ( INDEX = {child_request_index0}, DATA = {request0})" )

child_create_request_transaction1 = contract.functions.create_request ( DEPOSIT_AMOUNT - CHILD_REQUEST_AMOUNT ).build_transaction ({
    "from": child_address,
    "nonce": web3.eth.get_transaction_count ( child_address ),
    "gasPrice": 1
})

send_transaction ( child_create_request_transaction1, child_private_key )

account_balance = contract.functions.get_balance ( ).call ({
    "from": child_address
})

print ( f"ACCOUNT ( BALANCE = {account_balance} )" )

child_request_index1 = get_request_index ( contract )

request1 = contract.functions.get_request ( child_request_index1 ).call ({
    "from": child_address
})

print ( f"REQUEST ( INDEX = {child_request_index1}, DATA = {request1})" )

# mother approving request 0
print ( f"MOTHER APPROVING REQUEST {child_request_index0}" )
mother_approve_request_transaction = contract.functions.approve_request ( child_request_index0 ).build_transaction ({
    "from": mother_address,
    "nonce": web3.eth.get_transaction_count ( mother_address ),
    "gasPrice": 1
})
send_transaction ( mother_approve_request_transaction, mother_private_key )

child_balance  = web3.eth.get_balance ( child_address )

print ( f"CHILD ( BALANCE = {child_balance} )" )

account_balance = contract.functions.get_balance ( ).call ({
    "from": father_address
})

print ( f"ACCOUNT ( BALANCE = {account_balance} )" )

# father denying request 1
print ( f"FATHER DENYING REQUEST {child_request_index1}" )
father_deny_request_transaction = contract.functions.deny_request ( child_request_index1 ).build_transaction ({
    "from": father_address,
    "nonce": web3.eth.get_transaction_count ( father_address ),
    "gasPrice": 1
})
send_transaction ( father_deny_request_transaction, father_private_key )

child_balance  = web3.eth.get_balance ( child_address )

print ( f"CHILD ( BALANCE = {child_balance} )" )

account_balance = contract.functions.get_balance ( ).call ({
    "from": father_address
})

print ( f"ACCOUNT ( BALANCE = {account_balance} )" )