import secrets
from flask import Flask
from flask import request
from web3 import Web3
from web3 import HTTPProvider
from web3 import Account

TOKEN_PRICE = 300000

web3 = Web3 ( HTTPProvider ( "http://127.0.0.1:8545" ) )

application = Flask ( __name__ )

# create shop owner account
shop_owner_private_key = "0x" + secrets.token_hex ( 32 )
shop_owner_account     = Account.from_key ( shop_owner_private_key )
shop_owner_address     = shop_owner_account.address


def send_transaction ( transaction, private_key ):
    signed_transaction = web3.eth.account.sign_transaction ( transaction, private_key )
    transaction_hash   = web3.eth.send_raw_transaction ( signed_transaction.raw_transaction )
    receipt            = web3.eth.wait_for_transaction_receipt ( transaction_hash )

    return receipt

def read_file ( path ):
    with open ( path, "r" ) as file:
        return file.read ( )

abi      =  read_file ( "./solidity/output/Tokens.abi" )
bytecode =  read_file ( "./solidity/output/Tokens.bin" )
contract_address = None

@application.route ( "/create_token_order", methods = ["GET"] )
def create_token_order ( ):
    customer_address = request.args["customer_address"]
    token_amount     = int ( request.args["token_amount"] )

    contract = web3.eth.contract ( address = contract_address, abi = abi )

    transaction = contract.functions.buy_tokens ( token_amount ).build_transaction({
        "from": customer_address,
        "value": TOKEN_PRICE * token_amount,
        "nonce": web3.eth.get_transaction_count ( customer_address ),
        "gasPrice": 1
    })

    return transaction

@application.route ( "/token_balance", methods = ["GET"] )
def token_balance ( ):
    customer_address = request.args["customer_address"]

    contract = web3.eth.contract ( address = contract_address, abi = abi )

    token_balance = contract.functions.get_balance ( customer_address ).call ( )

    print ( token_balance )

    return str ( token_balance )


if ( __name__ == "__main__" ):
    # initialize shop owner account
    result = web3.eth.send_transaction ({
        "from": web3.eth.accounts[0],
        "to": shop_owner_address,
        "value": web3.to_wei ( 2, "ether" ),
        "gasPrice": 1
    })

    # create contract

    contract_creation_transaction = web3.eth.contract ( bytecode = bytecode, abi = abi )\
        .constructor ( TOKEN_PRICE ).build_transaction ({
        "from": shop_owner_address,
        "nonce": web3.eth.get_transaction_count ( shop_owner_address ),
        "gasPrice": 1
    })

    result = send_transaction ( contract_creation_transaction, shop_owner_private_key )

    contract_address = result["contractAddress"]

    application.run ( debug = True )