pragma solidity ^0.8.18;

contract Tokens {
    address payable owner;
    uint32 token_price;
    mapping ( address => uint256 ) balances;

    constructor ( uint32 _token_price ) {
        owner       = payable ( msg.sender );
        token_price = _token_price;
    }

    function buy_tokens ( uint32 amount ) external payable {
        require ( msg.value == amount * token_price, "Insufficient funds!" );
        balances[msg.sender] += amount;
    }

    function get_balance ( address customer ) external view returns ( uint256 ) {
        return balances[customer];
    }

    function spend_tokens ( address customer, uint32 amount ) external {
        require ( balances[customer] > amount, "Not enough tokens." );
        balances[customer] -= amount;
    }

    function withdraw ( ) external payable {
        owner.transfer ( address ( this ).balance );
    }
}