pragma solidity ^0.8.18;

contract FamilyWalletAdvanced {
    address payable father;
    address payable mother;
    address payable child;

    uint256 available_amount;

    enum Status {
        PENDING,
        APPROVED,
        DENIED
    }

    struct Request {
        uint256 amount;
        address payable creator;
        Status status;
    }

    event NewRequest ( uint32 index );

    Request[] requests;
    uint32 count;

    modifier only_family ( ) {
        require ( 
            msg.sender == father || msg.sender == mother || msg.sender == child, 
            "Only family members can access this account!" 
        );
        _;
    }

    constructor ( address payable _father, address payable _mother, address payable _child ) {
        father = _father;
        mother = _mother;
        child  = _child;
    }

    function deposit ( ) external payable only_family {
        available_amount += msg.value;
    }

    function get_balance ( ) external view only_family returns ( uint256 ) {
        return available_amount;
    }

    function create_request ( uint256 amount ) external payable only_family {
        require ( amount <= available_amount, "Insufficient funds!" );

        Request memory request;

        request.amount  = amount;
        request.creator = payable ( msg.sender );
        request.status  = Status.PENDING;

        requests.push ( request );

        available_amount -= amount;

        count++;

        emit NewRequest ( count - 1 );
    }

    function get_request ( uint32 index ) external view only_family returns ( uint256, Status, address ) {
        Request memory request = requests[index];

        return ( request.amount, request.status, request.creator );
    }

    function approve_request ( uint32 index ) external payable only_family {
        require ( msg.sender != child, "Child cannot approve requests!" );
        require ( requests.length > index , "Invalid index!" );

        Request memory request = requests[index];

        require ( request.creator != msg.sender, "You cannot approve your own request!" );
        require ( request.status == Status.PENDING, "Request not pending!" );

        request.creator.transfer ( request.amount );

        request.status = Status.APPROVED;
    }

    function deny_request ( uint32 index ) external only_family {
        require ( msg.sender != child, "Child cannot approve requests!" );
        require ( requests.length > index , "Invalid index!" );

        Request memory request = requests[index];

        require ( request.creator != msg.sender, "You cannot approve your own request!" );
        require ( request.status == Status.PENDING, "Request not pending!" );

        available_amount += request.amount;
        
        request.status = Status.DENIED;
    }
}