package mreza;

/**-----------------------------------------------------------------------------
 * Apstraktrna klasa Kasnjenje enkapsulira tip kasnjenja signala
------------------------------------------------------------------------------*/

public abstract class Kasnjenje {

    // zajednicko za sve tipove kasnjenja
    private int dt;
    protected Signal rezultat, kandidat;

    public Kasnjenje (int dt) {
        this.dt = dt;
        rezultat = kandidat = Signal.NEODREDJEN;
    }

    //zajednicki interfejs
    protected int uzmiDt() {return dt; }
    
    public Signal uzmiRezultat() { return rezultat; }

    protected void postaviRezultat (Signal s) { rezultat = s; }

    protected Signal uzmiKandidat () { return kandidat; }

    protected void postaviKandidat (Signal s) { kandidat = s; }

    // apstraktne metode koje zavise od konkretnih modela kasnjenja
    public abstract void otkucaj();

    public abstract void osvezi(JedKombElement e);

}