package mreza;

/**-----------------------------------------------------------------------------
 * Zica predstavlja pasivni element, izlaz najvise jednog kombinacionog
 * elementa, a ulaz za proizvoljni broj kombinacionih elemenata
------------------------------------------------------------------------------*/

public class Zica extends ElementKola {

    private Signal vrednost;
    private JedKombElement kolo; // <- da obezbedimo da se na nju veze max. 1 izlaz

    public Zica(JedKombElement e) {
        vrednost = Signal.NEODREDJEN;
        kolo = e; kolo.dodaj(this);
    }

    public Signal uzmiVrednost () { return vrednost; }
    
    public String ispisiVrednost () {
        return new String ("" + kolo.uzmiID() + kolo.nadjiBrojIzlaza(this) + vrednost);
    }

    public synchronized void azuriraj(Subjekat k) {
        if ((JedKombElement) kolo == k) {
            vrednost = ((JedKombElement) kolo).uzmiVrednost();
            obavesti();
        }
        else {
            // zica ne sme da primi poruku od bilo kog drugog kola
            // javi o gresci + vrednost = Signal.NEODREDJEN
        }
    }



}

/** @todo: Obezbediti da zica bude izlaz najvise jednog elementa - OK  */