package mreza;

/**-----------------------------------------------------------------------------
 * Subjekat.java - Apstraktni subjekat za posmatranje
 * Autor: Laslo Kraus
------------------------------------------------------------------------------*/

public abstract class Subjekat {

  public Subjekat () {
  }

  private Elem prvi, posl;

  // prijavljivanje novih posmatraca
  public synchronized void dodaj(IPosmatrac posm) {
    Elem novi = new Elem (posm);
    if (prvi == null) prvi = novi;
      else posl.sled = novi;
    posl = novi;
  }

  // odjavljivanje postojecih posmatraca
  public synchronized void brisi(IPosmatrac posm) {
    Elem tek = prvi, preth = null;
    while (tek!=null && tek.posm!=posm)
      { preth = tek; tek = tek.sled; }
    if (tek != null) {
      if (preth != null) preth.sled = tek.sled;
        else prvi = tek.sled;
      if (tek == posl) posl = preth;
    }
  }

  // obavestavanje registrovanih posmatraca
  protected synchronized void obavesti() {
    for (Elem tek=prvi; tek!=null; tek=tek.sled)
      tek.posm.azuriraj (this);
  }

  public class Elem {

    private IPosmatrac posm;
    private Elem sled;

    private Elem(IPosmatrac posm) { this.posm = posm; }

  } // class Elem

} // class Subjekat
