package mreza;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PrikazIzvora extends PrikazElementa {
    
    public PrikazIzvora(Izvor izvor) {
        super (izvor);
        JPanel prekidac = new JPanel (new GridLayout(1, 3));
        String[] oznaka = { Signal.NEODREDJEN.toString(),
                            Signal.NIZAK.toString(),
                            Signal.VISOK.toString() };
        CheckboxGroup grupa = new CheckboxGroup ();
        PromenaVrednosti osmatrac = new PromenaVrednosti ();
        for (int i = 0; i < 3; i++) {
            Checkbox cb = new Checkbox (oznaka[i], false);
            cb.setCheckboxGroup(grupa);
            prekidac.add (cb);
            cb.addItemListener(osmatrac);
        }
        add (prekidac, BorderLayout.SOUTH);
        azuriraj (null);
    }
    
    private class PromenaVrednosti implements ItemListener {
        public void itemStateChanged (ItemEvent e) {
            String s = ((Checkbox)(e.getSource())).getLabel();
            ((Izvor) elem).postaviVrednost (Signal.stringToSignal(s));
        }
    }
    
}
