package mreza;

import java.awt.*;
import javax.swing.*;

/** ----------------------------------------------------------------------------
 * Klasa PrikazElementa sluzi za graficko predstavljanje kombinacionog elementa
 * u vidu komponente JPanel, sa implementacijom IPosmatrac interfejsa
 * ---------------------------------------------------------------------------*/

public class PrikazElementa extends JPanel implements IPosmatrac {
    
    private JLabel[] ulaz, izlaz;
    protected KombElement elem;
    private JPanel ulaziIzlazi;
    
    public static final int PREFERRED_WIDTH = 80, PREFERRED_HEIGHT = 80;
    
    public PrikazElementa(KombElement elem) {
        this.elem = elem;
        elem.pretplataUlaziIzlazi(this);
        ulaz = new JLabel [elem.ispisiVrednostiUlaza().length];
        izlaz = new JLabel [elem.ispisiVrednostiIzlaza().length];
        setLayout (new BorderLayout ());
        setPreferredSize(new Dimension (PREFERRED_WIDTH, PREFERRED_HEIGHT));
        setBackground(Color.white);
        int maks = Math.max (ulaz.length, izlaz.length);
        ulaziIzlazi = new JPanel (new GridLayout (maks, 2), true);
        ulaziIzlazi.setBackground(Color.white);
        for (int i = 0; i < maks; i++) {
            if (i < ulaz.length)
                ulaziIzlazi.add (ulaz[i] = new JLabel ("???"), 2 * i);
            else
                ulaziIzlazi.add (new JLabel ("   "), 2 * i);
            if (i < izlaz.length)
                ulaziIzlazi.add (izlaz[i] = new JLabel ("???"), 2 * i + 1);
            else
                ulaziIzlazi.add (new JLabel ("   "), 2 * i + 1);
        }
        add (new JLabel (elem.tipElementa() + " " + elem.uzmiID()), 
            BorderLayout.NORTH
            );
        add (ulaziIzlazi, BorderLayout.CENTER);
    }
    
    public void azuriraj(Subjekat subj) {
        String[] ul = elem.ispisiVrednostiUlaza(),
                izl = elem.ispisiVrednostiIzlaza();
        for (int i = 0; i < Math.max (ulaz.length, izlaz.length); i++) {
            if (i < ulaz.length) ulaz[i].setText (ul[i]);
            if (i < izlaz.length) izlaz[i].setText (izl[i]);
        }
    }
 
}
