package mreza;

import java.io.*;

public class Parser {
    

    private LinijskiParser parser;
    private static final char[] ignorisi = { ' ', '\t' };
    private static final int TIP = 0, IME = 1, BR_ULAZA = 2, KASNJENJE = 2;
    private int stdKasnjenje = 2;
    private static Mreza glavnaMreza = new Mreza ('$', 0, 0); // TEST
    
    public Parser(Mreza m, String fajl) {
        glavnaMreza = m;
        parser = new LinijskiParser (fajl, ignorisi);
    }
    
    public void ispisiNiz (String[] niz) {
        for (int i = 0; i < niz.length; i++)
            System.out.print (niz[i] + " ");
        System.out.println();
    }
    
    public void parsirajKasnjenje () {
        String[] linija;
        try {
            linija = parser.parsirajLiniju();
        } catch (PraznaLinija p) { linija = null; }
        if (linija != null) stdKasnjenje = Integer.parseInt(linija[0]);
        System.out.println ("Std. kasnjenje log. kola: " + stdKasnjenje + " vrem. jedinica");
    }
    
    public void parsirajMrezu (Mreza mreza) {
        String[] linija;
        System.out.println ("Parsiranje mreze " + mreza.uzmiID());
        do {
            try {
                linija = parser.parsirajLiniju();
                ispisiNiz(linija);
                if (linija[0].equals("]")) break;
                parsirajElement (mreza, linija);
            }
            catch (PraznaLinija p) { linija = null; }
        }
        while (true);    // dok ne dodjemo do kraja mreze
        for (int i = 1; i < linija.length; i++) {
            System.out.println ("Povezujem mrezu: " + mreza.uzmiID() + " na izlaze: ");
            char veza = linija[i].charAt(0);
            String broj = linija[i].replace(linija[i].charAt(0), '0');
            try {
                mreza.poveziII (i - 1, mreza.nadjiElement(veza), Integer.parseInt(broj));
                System.out.println ( (i - 1) + " => " + mreza.nadjiElement(veza).uzmiID() + "." + Integer.parseInt(broj));
            } catch (GreskaNijeMreza e) { }
        }
        System.out.println ("Kraj parsiranja mreze " + mreza.uzmiID() );
    }
    
    public int nadjiString (String s, String[] niz) {
        for (int i = 0; i < niz.length; i++)
            if (niz[i].equals(s)) return i;
        return -1;
    }
    
    public void parsirajElement (Mreza mreza, String[] opis) {
        String[] elementi = {"src", "not", "and", "or", "nand", "nor", "xor", "net"};
        KombElement noviElement;
        int kasnjenje;  boolean zadatoKasnjenje;
        int ind = nadjiString (opis[0], elementi);
        boolean jesteMreza = false;
        
        try {
            kasnjenje = Integer.parseInt (opis[opis.length - 1]);
            zadatoKasnjenje = true;
            System.out.println ("ZK");
        } catch (NumberFormatException e) { 
            kasnjenje = stdKasnjenje;
            zadatoKasnjenje = false;
            System.out.println ("NZK");
        }
        
        if (ind == 0) {
            noviElement = new Izvor (opis[IME].charAt(0));
        }
        else {
            int pocetak = 2;           
            switch (ind) {
                case 1:
//                    if (opis.length > 3) {
//                        kasnjenje = Integer.parseInt(opis[opis.length - 1]);
//                        zadatoKasnjenje = true;
//                        System.out.println ("Kasnjenje " + kasnjenje);
//                    }
                    noviElement = new Invertor (opis[IME].charAt(0), kasnjenje);
                    pocetak = 2; break;
                case 2:
                    noviElement = new AndKolo 
                        (opis[IME].charAt(0), Integer.parseInt(opis[BR_ULAZA]), kasnjenje);
                    pocetak = 3; break;
                case 3:
                    noviElement = new OrKolo 
                        (opis[IME].charAt(0), Integer.parseInt(opis[BR_ULAZA]), kasnjenje);
                    pocetak = 3; break;
                case 4:
                    noviElement = new NandKolo 
                        (opis[IME].charAt(0), Integer.parseInt(opis[BR_ULAZA]), kasnjenje);
                    pocetak = 3; break;
                case 5:
                    noviElement = new NorKolo 
                        (opis[IME].charAt(0), Integer.parseInt(opis[BR_ULAZA]), kasnjenje);
                    pocetak = 3; break;
                case 6:
                    noviElement = new XorKolo 
                        (opis[IME].charAt(0), Integer.parseInt(opis[BR_ULAZA]), kasnjenje);
                    pocetak = 3; break;
                case 7:
                    noviElement = new Mreza (opis[IME].charAt(0), Integer.parseInt(opis[BR_ULAZA]),  
                                            Integer.parseInt(opis[BR_ULAZA + 1]));
                    pocetak = 4; jesteMreza = true;
                    break;
                default: 
                System.out.println ("Greska - nepostojeci element");
                noviElement = null;
                System.exit(1);
            }
            int gornjaGranica = opis.length;
            if (zadatoKasnjenje) gornjaGranica = opis.length - 1;
            for (int i = pocetak; i < gornjaGranica; i++) {
                char veza = opis[i].charAt(0);
                String broj = opis[i].replace(opis[i].charAt(0), '0');
                if (veza == '\\')    // veza sa roditeljskom mrezom
                    noviElement.poveziUU (i - pocetak, mreza, Integer.parseInt(broj));
                else if (veza == '?')
                    noviElement.poveziUI (i - pocetak, Izvor.NeodredjeniIzvor, Integer.parseInt(broj));
                else
                    noviElement.poveziUI (i - pocetak, mreza.nadjiElement(veza), Integer.parseInt(broj));
            }
        }
        mreza.dodajElement(noviElement);
        if (jesteMreza) parsirajMrezu((Mreza)noviElement);
        else Casovnik.instanca().dodaj(noviElement);
    }
    
    public static void main (String[] varg) {
        Parser p = new Parser(glavnaMreza, "c:/dusan/oos/mreza/mreza.txt"); // d:/projekat/mreza/mreza.txt
        p.parsirajMrezu(glavnaMreza);
        Mreza.glavnaMreza = glavnaMreza;
        
    }

}
