package mreza;

import java.io.*;

/**-----------------------------------------------------------------------------
 * LinijskiParser sadrzi metode za citanje linije teksta iz ulazne datoteke
 * i njihovo pretvaranje u nizove stringova.
 * Koriscenje : kao deo slozenijeg parsera zaduzen za citanje liniju po liniju
 -----------------------------------------------------------------------------*/
public class LinijskiParser {
    
    private RandomAccessFile fajl;  // ulazna datoteka
    private char[] ignorisi;        // skup znakova koji se preskacu (ignorisu) - delimiteri
    
    public LinijskiParser(String imeFajla, char[] ignorisi) {
        try {
            fajl = new RandomAccessFile (imeFajla, "r");
            this.ignorisi = ignorisi;
       }
        catch (FileNotFoundException e) { 
            System.out.println ("Nema fajla!"); 
            System.exit(1);
        }
    }
    
    private boolean nadjen (char[] niz, char elem) {
        for (int i = 0; i < niz.length; i++)
            if (niz[i] == elem) return true;
        return false;
    }
    
    public String[] stringToStringArray (String str, char[] ignoreChars) {
        
        String[] radni = new String [str.length()]; // inicijalno predvidjeni
        StringBuffer temp = new StringBuffer ();
        int brojac = 0, pozicija = 0;
        
        while (brojac < str.length()) {
            while (brojac < str.length() && nadjen(ignoreChars, str.charAt(brojac))) 
                brojac++;
            while (brojac < str.length() && !nadjen(ignoreChars, str.charAt(brojac))) 
                temp.append(str.charAt(brojac++));
            if (temp.length() > 0) {
                radni[pozicija++] = temp.toString();
                temp = new StringBuffer ();
            }
        }
        String[] rezultat = new String [pozicija];
        for (int i = 0; i < pozicija; i++) {
            rezultat[i] = radni[i];
        }
        return rezultat;
    }
    
     public String[] parsirajLiniju () throws PraznaLinija {
        String[] rezultat; String temp = new String ();
        try {
            if ((temp = fajl.readLine()) == null || temp.length() == 0) throw new PraznaLinija ();
        } catch (IOException e) { }
        return stringToStringArray (temp, ignorisi);
    }
    
}
