package mreza;

public abstract class KombElement extends ElementKola implements Runnable {

  private char ID;
  protected Thread nit;
  protected Zica ulaz[], izlaz[];   // ulaze/izlaze treba da vide i naslednici

  KombElement (char ID, int ulazi, int izlazi) {
    this.ID = ID; nit = new Thread (this);
    ulaz = new Zica [ulazi];
    izlaz = new Zica [izlazi];
  }

  public void start () { nit.start(); }

  public char uzmiID () { return ID; }
  
  public KombElement nadjiElement (char ID) {
      if (this.ID == ID) return this;
      else return null;
  }
  
  public int nadjiBrojIzlaza (Zica z) {
      for (int i = 0; i < izlaz.length; i++)
          if (izlaz[i] == z) return i;
      return -1;
  }
  
  public synchronized String[] ispisiVrednostiUlaza () {
      String[] rez = new String [ulaz.length];
      for (int i = 0; i < ulaz.length; i++)
          rez[i] = ulaz[i].ispisiVrednost();
      return rez;
  }
  
  public synchronized String[] ispisiVrednostiIzlaza () {
      String[] rez = new String [izlaz.length];
      for (int i = 0; i < izlaz.length; i++)
          rez[i] = izlaz[i].ispisiVrednost();
      return rez;
  }
  
/* Funkcija kojom se element za prikazivanje elementa prijavljuje kod svih
 * ulaza i izlaza zbog blagovremenog prikazivanja promena
 */
  public void pretplataUlaziIzlazi (IPosmatrac posm) {
      for (int i = 0; i < Math.max(ulaz.length, izlaz.length); i++) {
          if (i < ulaz.length) ulaz[i].dodaj(posm);
          if (i < izlaz.length) izlaz[i].dodaj(posm);
      }
  }
  
  public PrikazElementa prikaziElement () {
      return new PrikazElementa (this);
  }
  
  public abstract String ispisiVrednost() ;
  
  public abstract String tipElementa ();

  // povezivanje odredjenog ulaza za odredjeni izlaz elementa 'ke'
    public void poveziUI (int mojUlaz, KombElement ke, int brIzlaza) {
        try {
            ulaz[mojUlaz] = ke.izlaz[brIzlaza];
        } catch (IndexOutOfBoundsException e) { }
    }
  
    public void poveziII(int mojIzlaz, KombElement ke, int brIzlaza) throws GreskaNijeMreza {
        izlaz[mojIzlaz] = ke.izlaz[brIzlaza];
    }

    public void poveziUU(int mojUlaz, KombElement ke, int brUlaza) {
        ulaz[mojUlaz] = ke.ulaz[brUlaza];
    }

} // class KombElement