package mreza;

public abstract class JedKombElement extends KombElement {

    private int dt, brojac;    
    protected Signal vrednost;

    public JedKombElement (char ID, int ulaza, int dt) {
        super (ID, ulaza, 1);
        brojac = this.dt = dt;
        vrednost = Signal.NEODREDJEN;
        izlaz[0] = new Zica (this); // <- Jednostavni KE kreira svoj izlaz
    }                               
    
    public Signal uzmiVrednost () { return vrednost; }
    
    public Signal uzmiVrednostIzlaza () { return izlaz[0].uzmiVrednost(); }
    
    public String ispisiVrednost () { return new String ("" + uzmiID() + ": " + uzmiVrednostIzlaza() + " "); }

  // Logicka funkcija zavisi od konkretne vrste kola
    public abstract Signal logickaFunkcija ();

  // funkcija koja uzima vrednosti svih ulaza i na osnovu toga izracunava
  // kandidat-vrednost izlaza - TEMPLATE METHOD
    public synchronized void azuriraj(Subjekat subj) {
        boolean promenjenUlaz = false;
        Signal temp = logickaFunkcija();
        for (int i = 0; i < ulaz.length && !promenjenUlaz; i++)
            if (ulaz[i] == subj) promenjenUlaz = true;
        if (temp != vrednost) {
            vrednost = temp;
            brojac = dt;
        }
        else if (! promenjenUlaz)
            if (brojac >0) brojac--;
        if (brojac == 0)
            obavesti();
    }
    
    public void poveziUI (int mojUlaz, KombElement ke, int brIzlaza) {
        super.poveziUI(mojUlaz, ke, brIzlaza);
        ulaz[mojUlaz].dodaj(this);
    }

    public void poveziII(int mojIzlaz, KombElement ke, int brIzlaza) throws GreskaNijeMreza {
        throw new GreskaNijeMreza();
    }

    public void poveziUU(int mojUlaz, KombElement ke, int brUlaza) {
        super.poveziUU(mojUlaz, ke, brUlaza);
        ulaz[mojUlaz].dodaj(this);
    }

    public void run() {
        while (true) {
            try {
                nit.sleep(1000);
            } catch (InterruptedException e) { }
        }
    }
}