package mreza;

/* Inercijalno kasnjenje je ono kod koga impuls na ulazu mora biti duzi
od kasnjenja kroz element da bi se preneo na izlaz. */

public class  Inercijalno extends Kasnjenje {

  private int brojac;
  private JedKombElement kolo;

  public Inercijalno(int dt) {
    super(dt);
    brojac = dt;
  }

  // Ako je signal stabilan na ulazu dovoljno dugo, treba ga preneti na izlaz
  public void otkucaj() {
    if (brojac > 0) {
      if (--brojac == 0) rezultat = kandidat;
    }
  }

  // Ako maticno kolo promeni stanje, treba resetovati kolo za kasnjenje
  public void osvezi(JedKombElement e) {
    kandidat = e.uzmiVrednost();
    if (uzmiDt() == 0) 
        rezultat = kandidat;
    else 
        brojac = uzmiDt();
  }

}