package mreza;

/**-----------------------------------------------------------------------------
 * Casovnik.java - casovnik koji vodi simulaciju mreze
 * Koriscen je projektni uzorak SINGLETON
 * Autor: Dusan Zecevic <zdusan@softhome.net>
------------------------------------------------------------------------------*/

public class Casovnik extends Subjekat implements Runnable, IPosmatrac {

  private Thread nit;
  private int interval = 500;
  private boolean radi = true, gotovo = false;

  private static Casovnik instanca; // SINGLETON

  private Casovnik () { nit = new Thread (this); }

  public void start () { nit.start(); }

  public synchronized void kreni () {
    radi = true;
    notify();
  }

  public void stani () {radi = false; }

  public void zavrsi () { gotovo = true; }
  
  public synchronized void postaviInterval(int vred) {
      interval = vred;
  }
  
  public synchronized int uzmiInterval () { return interval; } 

  public void run() {
    while (! gotovo) {
      synchronized (this) {
        while (! radi)
          try {
            wait ();
          }
          catch (InterruptedException g) { }
      }
    if (gotovo) break;
      obavesti ();
      try { 
          nit.sleep(interval); 
      }
      catch (InterruptedException g) { }
    }
  }

  // promena brzine rada casovnika
  public void azuriraj (Subjekat subj) {
      /** @todo: Treba predvideti konkretan objekat i odg. metod */
      // interval = ((Nesto)subj).uzmiVrednost();
  }

/* Implementacija projektnog uzorka SINGLETON - treba nam samo jedan casovnik
   u sistemu      */

  public static Casovnik instanca () {
    if (instanca == null) instanca = new Casovnik();
    return instanca;
  }
}
