package mreza;

/**-----------------------------------------------------------------------------
  * Klasa koja enkapsulira elektricne signale.
  * Definisane su i elementarne logicke operacije nad signalima 
------------------------------------------------------------------------------*/

public class Signal {

  // moguce vrednosti signala NIZAK(0), VISOK(1) i NEODREDJEN(2)
  private static final int NULA = 0, JEDAN = 1, X = -1;
  private int v;
  private Signal vrednost;
  
  // moguce vrednosti signala enkapsulirane su u 3 staticka objekta klase Signal
  public static final Signal NIZAK = new Signal (NULA);
  public static final Signal VISOK = new Signal (JEDAN);
  public static final Signal NEODREDJEN = new Signal (X);

  // privatni konstruktor - sluzi samo za inicijalizaciju
  private Signal (int v) {
    this.v = v;
    this.vrednost = this;
  }
  
  public Signal notOp () {
    if (vrednost == VISOK)
      return NIZAK;
    else if (vrednost == NIZAK)
      return VISOK;
    return NEODREDJEN;
  }

  public Signal andOp (Signal s) {
    if (vrednost == NIZAK || s.vrednost == NIZAK)
      return NIZAK;
    else
    if (vrednost == VISOK && s.vrednost == VISOK)
        return VISOK;
    return NEODREDJEN;
    
  }

  public Signal orOp (Signal s) {
    if (vrednost == VISOK || s.vrednost == VISOK)
      return VISOK;
    else
    if (vrednost == NIZAK && s.vrednost == NIZAK)
      return NIZAK;
    return NEODREDJEN;
  }

  public Signal nandOp (Signal s) {
    Signal pom = this.andOp(s);
    return pom.notOp();
  }

  public Signal norOp (Signal s) {
    Signal pom = this.orOp(s);
    return pom.notOp();
  }
  
  public Signal xorOp (Signal s) {
      if (vrednost == NEODREDJEN || s.vrednost == NEODREDJEN)
          return NEODREDJEN;
      else if (vrednost != s.vrednost)
          return VISOK;
      else return NIZAK;
  }

  public String toString() {
    if (vrednost == NIZAK)
        return ("-");
    else if (vrednost == VISOK)
        return ("+");
    else 
        return ("X");
  }

  public static Signal stringToSignal (String s) {
      if (s.equals (NIZAK.toString())) return NIZAK;
      else if (s.equals (VISOK.toString())) return VISOK;
      else return NEODREDJEN;
  }
  
} // class Signal