package mreza;

import java.awt.*;
import javax.swing.*;

public class Mreza extends KombElement {
    
    private KombElement[] element;
    private int brojElemenata;
    
    private static int upleft_x = 100, upleft_y = 150;
    
    public static Mreza glavnaMreza = new Mreza ('$', 0, 0);

    public Mreza(char ID, int ulaza, int izlaza) {
        super(ID, ulaza, izlaza);
        element = new KombElement [5];
        brojElemenata = 0;
    }

    public void dodajElement (KombElement k) {
        if (brojElemenata == element.length) {  // prosirivanje niza
            KombElement[] pomocni = new KombElement [brojElemenata + 5];
            for (int i = 0; i < brojElemenata; i++)
                pomocni[i] = element[i];
            element = pomocni;
        }
        element[brojElemenata++] = k;
    }
    
    public KombElement nadjiElement (char ID) {
        KombElement temp;
        if (uzmiID() == ID) return (temp = this);
        else {
            for (int i = 0; i < brojElemenata; i++)
                if ((temp = element[i].nadjiElement(ID)) != null) return temp;
        }
        return null;
    }
    
    public String ispisiVrednost () {
        StringBuffer s = new StringBuffer ("<Mreza " + uzmiID() +  " ");
        for (int i = 0; i < brojElemenata; i++)
            s.append(element[i].ispisiVrednost());
        s.append('>');
        return s.toString();
    }
    
    public void start() {
        for (int i = 0; i < brojElemenata; i++)
            element[i].start();
    }
    
    public PrikazElementa prikaziElement () {
        return new PrikazAgregata (this);
    }
    
    public JFrame prikaziMrezu () {
        PrikazMreze slika = new PrikazMreze (this);
        slika.getContentPane().setLayout (new FlowLayout ());
        slika.podesiVelicinu (brojElemenata);
        PrikazElementa p;
        for (int i = 0; i < brojElemenata; i++ ) {
            p = element[i].prikaziElement();
            slika.getContentPane().add (p);
        }
        return slika;
    }
    
    public void azuriraj(Subjekat parm1) {
        /**@todo: implement this mreza.ElementKola abstract method*/
    }

    public void run() {
        /**@todo: implement this mreza.ElementKola abstract method*/
    }

    public String tipElementa() {
        return "NET";
    }
    
}