import java.io.*;

public class FileReader {
    
    private RandomAccessFile fajl;
    private char[] ignorisi = {' ', '\t', 'a'};
    
    private class PraznaLinija extends Exception {
    }
    
    public FileReader(String imeFajla) {
        try {
            fajl = new RandomAccessFile (imeFajla, "r");
       }
        catch (FileNotFoundException e) { System.out.println ("Nema fajla!"); System.exit(1);}
    }
    
    public String[] parsirajLiniju () throws PraznaLinija {
        String[] rezultat; String temp = new String ();
        try {
            if ((temp = fajl.readLine()) == null) throw new PraznaLinija ();
        } catch (IOException e) { }
     //   return rezultat = temp.split(" ");
        return stringToStringArray (temp, ignorisi);
    }
    
    private boolean nadjen (char[] niz, char elem) {
        for (int i = 0; i < niz.length; i++)
            if (niz[i] == elem) return true;
        return false;
    }
    
    public String[] stringToStringArray (String str, char[] ignoreChars) {
        
        String[] radni = new String [str.length()]; // inicijalno predvidjeni
        StringBuffer temp = new StringBuffer ();
        int brojac = 0, pozicija = 0;
        
        while (brojac < (str.length() - 1)) {
            while (nadjen(ignoreChars, str.charAt(brojac)) && brojac < (str.length() - 1)) 
                brojac++;
            while (!nadjen(ignoreChars, str.charAt(brojac)) && brojac < (str.length() - 1)) 
                temp.append(str.charAt(brojac++));
            if (temp.length() > 0) {
                radni[pozicija++] = temp.toString();
                temp = new StringBuffer ();
            }
        }
        String[] rezultat = new String [pozicija];
        for (int i = 0; i < pozicija; i++) {
            rezultat[i] = radni[i];
        }
        return rezultat;
    }

    public String[] stringToStringArray (String str) {
        
        String[] radni = new String [str.length()]; // inicijalno predvidjeni
        StringBuffer temp = new StringBuffer ();
        int brojac = 0, pozicija = 0;
        
        while (brojac < (str.length() - 1)) {
            while (str.charAt(brojac) == ' ' && brojac < (str.length() - 1)) 
                brojac++; // skip blanks
            while (str.charAt(brojac) != ' '&& brojac < (str.length() - 1)) 
                temp.append(str.charAt(brojac++));
            if (temp.length() > 0) {
                radni[pozicija++] = temp.toString();
                temp = new StringBuffer ();
            }
        }
        String[] rezultat = new String [pozicija];
        for (int i = 0; i < pozicija; i++) {
            rezultat[i] = radni[i];
        }
        return rezultat;
    }
    

    public static void main (String[] argv) {
        
        FileReader fr = new FileReader ("d:/projekat/Mreza/testParsera.txt");
        String[] stampa;
        boolean endOfFile = false;
        
        while (! endOfFile)  {
            try {
                stampa = fr.parsirajLiniju();
                for (int i = 0; i < stampa.length; i++)
                    System.out.print (stampa[i] + " ");
                System.out.println ();
            }
            catch (PraznaLinija p) { endOfFile = true; }
        }
    }
}
