/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet loaded = new HashSet();
    private static LoaderAction loaderAction = new DefaultAction();
    private static boolean usingJNLPAppletLauncher;
    private static Method jnlpLoadLibraryMethod;

    public static void disableLoading() {
        NativeLibLoader.setLoadingAction(null);
    }

    public static void enableLoading() {
        NativeLibLoader.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        NativeLibLoader.loaderAction = loaderAction;
    }

    private static synchronized void loadLibrary(String string, String[] stringArray, boolean bl, boolean bl2) {
        if (loaderAction != null && !loaded.contains(string)) {
            loaderAction.loadLibrary(string, stringArray, bl, bl2);
            loaded.add(string);
        }
    }

    public static void loadCore() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NativeLibLoader.loadLibrary("jogl", null, false, false);
                return null;
            }
        });
    }

    public static void loadAWTImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit();
                boolean bl = System.getProperty("os.name").equals("Mac OS X");
                String[] stringArray = new String[]{"jawt"};
                NativeLibLoader.loadLibrary("jogl_awt", stringArray, !bl, false);
                return null;
            }
        });
    }

    public static void loadCgImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = new String[]{"cg", "cgGL"};
                NativeLibLoader.loadLibrary("jogl_cg", stringArray, true, true);
                return null;
            }
        });
    }

    private static void loadLibraryInternal(String string) {
        if (usingJNLPAppletLauncher && !string.equals("jawt")) {
            try {
                if (jnlpLoadLibraryMethod == null) {
                    Class<?> clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    jnlpLoadLibraryMethod = clazz.getDeclaredMethod("loadLibrary", String.class);
                }
                jnlpLoadLibraryMethod.invoke(null, string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            System.loadLibrary(string);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.jnlp.applet.launcher");
                usingJNLPAppletLauncher = Boolean.valueOf(string);
                return null;
            }
        });
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        public void loadLibrary(String string, String[] stringArray, boolean bl, boolean bl2) {
            if (bl) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        NativeLibLoader.loadLibraryInternal(stringArray[i]);
                        continue;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (bl2 || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) continue;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            NativeLibLoader.loadLibraryInternal(string);
        }
    }

    public static interface LoaderAction {
        public void loadLibrary(String var1, String[] var2, boolean var3, boolean var4);
    }
}

