/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import action.ActGraph;
import algorithm.Algorithm;
import error.Error;
import gui.graph.DrawGraphDialog;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import structure.ObservabileElement;
import structure.ObservabileGraph;
import structure.ObservabileVariable;
import view.AbstractView;
import view.graph.GraphView;
import view.graphics.graph.Branch2D;
import view.graphics.graph.Node2D;
import viewer.AbstractViewer;

public class GraphViewer
extends AbstractViewer {
    private LinkedList<Node2D> nodes;
    private LinkedList<Branch2D> branches;
    private ObservabileVariable[] structures;
    private boolean openDrawGraphDialog;

    public GraphViewer(AbstractView view) {
        super(view);
    }

    public boolean load(AbstractViewer p) {
        this.openDrawGraphDialog = false;
        this.nodes = ((GraphViewer)p).nodes;
        this.branches = ((GraphViewer)p).branches;
        this.structures = ((GraphViewer)p).structures;
        return super.load(p);
    }

    public void load(ObservabileVariable[] structures) throws Error {
        this.openDrawGraphDialog = false;
        this.structures = structures;
        Algorithm a = null;
        AbstractView v = null;
        try {
            v = (AbstractView)this.getView().getClass().newInstance();
            a = (Algorithm)this.getView().getAlgorithm().getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ObservabileVariable o : structures) {
            o.setAlghorithm(a);
        }
        ((ObservabileGraph)structures[0]).resetNodeAndBranchStatus();
        a.makeStructures(structures);
        ObservabileVariable[] tmp = new ObservabileVariable[structures.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = structures[i].clone();
        }
        a.run(structures);
        v.setViewer(this);
        v.setAlgorithm(a);
        v.getActions().addFirst(new ActGraph("Start structure", tmp, -1, null));
        this.setView(v);
        this.notifySimulationListeners();
        this.repaint();
    }

    public void loadAdditionalObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.nodes = (LinkedList)in.readObject();
        this.branches = (LinkedList)in.readObject();
        for (Node2D n : this.nodes) {
            n.setPaint(Node2D.DEFAULT);
            n.setSelected(false);
        }
        for (Branch2D b : this.branches) {
            b.setColor(Color.BLACK);
            b.setSelected(false);
        }
        ((GraphView)this.getView()).setGraph(this.nodes, this.branches);
    }

    public void saveStructures(ObjectOutputStream out) throws IOException {
        super.saveStructures(out);
        out.writeObject(this.nodes);
        out.writeObject(this.branches);
    }

    private void openDrawGraphDialog() throws Error {
        Algorithm alg = null;
        AbstractView view = null;
        try {
            view = (AbstractView)this.getView().getClass().newInstance();
            alg = (Algorithm)this.getView().getAlgorithm().getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        DrawGraphDialog d = new DrawGraphDialog(this);
        int ret = -1;
        if (this.nodes != null) {
            ret = JOptionPane.showConfirmDialog(this, "Do you wish to modify the existing graph?", "Question Dialog", 0);
        }
        if (ret == 0) {
            d.setNodes(this.nodes);
            d.setBranches(this.branches);
            d.setGraph((ObservabileGraph)this.structures[0]);
        }
        d.setVisible(true);
        this.nodes = d.getNodes();
        this.branches = d.getBranches();
        this.structures = new ObservabileVariable[3];
        this.structures[0] = d.getGraph();
        this.structures[1] = new ObservabileElement(alg, 1);
        this.structures[2] = new ObservabileElement(alg, 2);
        this.structures[0].setAlghorithm(alg);
        if (this.nodes.size() > 0) {
            ((ObservabileElement)this.structures[1]).writeValue(this.nodes.getFirst().getName());
            ((ObservabileElement)this.structures[2]).writeValue(this.nodes.getLast().getName());
        }
        alg.makeStructures(this.structures);
        ObservabileVariable[] tmp = new ObservabileVariable[this.structures.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.structures[i].clone();
        }
        alg.run(this.structures);
        view.setAlgorithm(alg);
        view.getActions().addFirst(new ActGraph("Start structure", tmp, -1, null));
        ((GraphView)view).setGraph(this.nodes, this.branches);
        this.setView(view);
        this.notifySimulationListeners();
        this.openDrawGraphDialog = false;
        this.repaint();
    }

    public void processActions() throws Error {
        if (this.openDrawGraphDialog) {
            this.openDrawGraphDialog();
        }
        super.processActions();
    }

    public boolean isOpenDrawGraphDialog() {
        return this.openDrawGraphDialog;
    }

    public void setOpenDrawGraphDialog(boolean openDrawGraphDialog) {
        this.openDrawGraphDialog = openDrawGraphDialog;
    }
}

