/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import algorithm.Algorithm;
import error.Error;
import java.awt.Graphics;
import java.awt.Graphics2D;
import structure.ObservabileBinaryTree;
import structure.ObservabileVariable;
import view.AbstractView;
import viewer.AbstractViewer;

public class BinaryTreeViewer
extends AbstractViewer {
    public BinaryTreeViewer(AbstractView view) {
        super(view);
    }

    public void load(ObservabileVariable[] structures) throws Error {
        Algorithm a = null;
        AbstractView v = null;
        boolean error = false;
        try {
            v = (AbstractView)this.getView().getClass().newInstance();
            a = (Algorithm)this.getView().getAlgorithm().getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ObservabileVariable o : structures) {
            o.setAlghorithm(a);
        }
        if (!(structures[0] instanceof ObservabileBinaryTree)) {
            structures = a.makeStructures(null);
            error = true;
        }
        a.run(structures);
        v.setViewer(this);
        v.setAlgorithm(a);
        this.setView(v);
        if (error) {
            throw new ClassCastException("invalid structure");
        }
        this.notifySimulationListeners();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setPaint(this.getBackgroundColor());
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getView().paint(g2D);
    }
}

