/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import algorithm.Algorithm;
import error.Error;
import structure.ObservabileArray;
import structure.ObservabileVariable;
import view.AbstractView;
import viewer.AbstractViewer;

public class ArrayViewer
extends AbstractViewer {
    public ArrayViewer(AbstractView view) {
        super(view);
    }

    public void load(ObservabileVariable[] structures) throws Error {
        Algorithm a = null;
        AbstractView v = null;
        try {
            v = (AbstractView)this.getView().getClass().newInstance();
            a = (Algorithm)this.getView().getAlgorithm().getClass().newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        ObservabileArray array = (ObservabileArray)structures[0];
        Object[] tmp = new String[array.getNumOfElem()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = array.readElem(i);
        }
        structures = a.makeStructures(tmp);
        a.run(structures);
        v.setViewer(this);
        v.setAlgorithm(a);
        this.setView(v);
        this.notifySimulationListeners();
        this.repaint();
    }
}

