/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import error.Error;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import structure.ObservabileVariable;
import view.AbstractView;
import view.ViewMouseAdapter;
import viewer.SimulationListener;

public abstract class AbstractViewer
extends JPanel
implements Runnable,
Serializable {
    private AbstractView view;
    private boolean finished;
    private boolean stepByStep;
    private boolean paused = true;
    private boolean beginning = true;
    private double speedMultiplier = 1.0;
    private int pauseInterval = 150;
    private Color backgroundColor = new Color(220, 220, 220);
    private ViewMouseAdapter m;
    private transient LinkedList<SimulationListener> listeners = new LinkedList();
    public static final int DEFAULT_PAUSE = 150;

    public AbstractViewer(final AbstractView view) {
        this.m = new ViewMouseAdapter(this);
        this.addMouseMotionListener(this.m);
        this.addMouseWheelListener(this.m);
        this.addMouseListener(this.m);
        this.setCursor(new Cursor(13));
        this.setDoubleBuffered(true);
        this.setView(view);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                view.setWidth(AbstractViewer.this.getWidth());
                view.setHeight(AbstractViewer.this.getHeight());
                AbstractViewer.this.repaint();
            }
        });
    }

    public String getSpeed() {
        return String.format("%1.2fx", 1.0 / this.speedMultiplier);
    }

    public boolean hasWork() {
        if (this.view == null) {
            return false;
        }
        if (this.view.getActions() != null) {
            return this.view.getActions().size() > 1;
        }
        return false;
    }

    public void addSimulationFinishedListener(SimulationListener s) {
        if (!this.listeners.contains(s)) {
            this.listeners.add(s);
        }
    }

    public void removeSimulationFinishedListener(SimulationListener s) {
        this.listeners.remove(s);
    }

    public RenderedImage createImage() {
        BufferedImage img = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        this.paint(img.getGraphics());
        return img;
    }

    public void reset() throws Error {
        this.setBeginning(true);
        this.stepByStep = false;
        this.view.reset();
        this.notifySimulationListeners();
    }

    public synchronized void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setPaint(this.backgroundColor);
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.view.paint(g2D);
    }

    public synchronized void increaseSpeed() {
        this.speedMultiplier /= 2.0;
        this.speedMultiplier = this.speedMultiplier < 0.125 ? 0.125 : this.speedMultiplier;
        this.pauseInterval = (int)(150.0 * this.speedMultiplier);
        this.view.setTopLabel(this.getSpeed());
    }

    public synchronized void decreaseSpeed() {
        this.speedMultiplier *= 2.0;
        this.speedMultiplier = this.speedMultiplier > 8.0 ? 8.0 : this.speedMultiplier;
        this.pauseInterval = (int)(150.0 * this.speedMultiplier);
        this.view.setTopLabel(this.getSpeed());
    }

    public synchronized void stop() throws Error {
        this.reset();
        this.setPaused(true);
        if (this.isFinished()) {
            this.setFinished(false);
        }
        this.repaint();
    }

    public synchronized boolean next() throws Error {
        if (this.isFinished()) {
            this.setFinished(false);
        }
        this.setBeginning(false);
        this.setPaused(true);
        this.setStepByStep(true);
        this.getView().nextStep();
        this.notify();
        return this.getView().getCurrentIndex() >= this.getView().getActions().size() - 1;
    }

    public synchronized void play() throws Error {
        if (this.isFinished()) {
            this.setFinished(false);
            this.reset();
        }
        this.setBeginning(false);
        this.notify();
        this.setPaused(false);
    }

    public synchronized void previous() throws Error {
        this.setPaused(true);
        this.setStepByStep(true);
        if (this.getView().previousStep()) {
            this.setBeginning(true);
        }
        if (this.isFinished()) {
            this.setFinished(false);
        }
        this.notify();
    }

    public boolean load(AbstractViewer p) {
        Class<?> c2;
        Class<?> c1 = this.view.getAlgorithm().getClass();
        if (!c1.equals(c2 = p.view.getAlgorithm().getClass())) {
            return false;
        }
        this.setCursor(p.getCursor());
        this.setView(p.view);
        this.stepByStep = p.stepByStep;
        this.finished = p.finished;
        this.paused = p.paused;
        this.backgroundColor = p.backgroundColor;
        return true;
    }

    public abstract void load(ObservabileVariable[] var1) throws Error;

    public void loadAdditionalObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    public void saveStructures(ObjectOutputStream out) throws IOException {
        ObservabileVariable[] structures = this.getView().getCurrentStructures();
        if (structures != null) {
            out.writeObject(structures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processActions() throws Error {
        this.view.setViewer(this);
        while (true) {
            try {
                while (true) {
                    AbstractViewer abstractViewer = this;
                    synchronized (abstractViewer) {
                        if (this.paused) {
                            this.wait();
                        }
                    }
                    if (this.stepByStep) {
                        this.stepByStep = false;
                    } else if (this.view.nextStep()) {
                        this.finished = true;
                        this.paused = true;
                    }
                    if (this.finished) continue;
                    this.view.processCurrentAction(this.pauseInterval);
                }
            }
            catch (InterruptedException e) {
                this.view.interrupt();
                continue;
            }
            break;
        }
    }

    public void run() {
        try {
            this.processActions();
        }
        catch (Error e) {
            JOptionPane.showMessageDialog(this, e.getErrorMessage(), "Error Dialog", 0);
        }
    }

    public boolean isBeginning() {
        return this.beginning;
    }

    public void setBeginning(boolean beginning) {
        this.beginning = beginning;
    }

    public void notifySimulationListeners() {
        int index = this.view.getCurrentIndex();
        for (SimulationListener sfl : this.listeners) {
            sfl.stateChanged(index);
            if (!this.finished) continue;
            sfl.simulationFinished();
        }
    }

    public AbstractView getView() {
        return this.view;
    }

    public void setView(AbstractView view) {
        this.view = view;
        this.m.setView(view);
        this.repaint();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isStepByStep() {
        return this.stepByStep;
    }

    public void setStepByStep(boolean stepByStep) {
        this.stepByStep = stepByStep;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public int getPauseInterval() {
        return this.pauseInterval;
    }

    public void setPauseInterval(int pauseInterval) {
        this.pauseInterval = pauseInterval;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

