/*
 * Decompiled with CFR 0.152.
 */
package view.tree.huffman;

import action.ActBST;
import java.awt.Graphics2D;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;
import view.BSTNodeVisibility;
import view.graphics.tree.AnimatedKey;
import view.graphics.tree.BinaryTreeNode2D;
import view.graphics.tree.ComplexNode2D;
import view.tree.AbstractBinaryTreeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HuffmanView
extends AbstractBinaryTreeView {
    AnimatedKey anim = null;
    protected ComplexNode2D tempNode = null;

    public void setKeyDistance(int x) {
        AnimatedKey.DISTANCE = x;
        if (x > 0) {
            this.setTopLabel("Animated key position: Right");
        } else if (x < 0) {
            this.setTopLabel("Animated key position: Left");
        } else {
            this.setTopLabel("Animated key position: Center");
        }
    }

    public int getKeyDistance() {
        return AnimatedKey.DISTANCE;
    }

    protected void animate(ComplexNode2D node, ComplexNode2D from, ComplexNode2D to) throws InterruptedException {
        this.anim = new AnimatedKey(this);
        this.anim.setNewKey(node);
        this.tempNode = node;
        this.anim.setParameters(from, to);
        this.anim.start();
        this.anim.join();
        this.anim = null;
        this.tempNode = null;
    }

    public void animateSide(BinaryTreeNode2D node, int val) throws InterruptedException {
        this.anim = new AnimatedKey(this);
        this.anim.setNewKey(node);
        node.setPaint(BinaryTreeNode2D.GREEN);
        this.anim.setParameters(node, new BinaryTreeNode2D((int)node.getX() + val, (int)node.getY()));
        this.anim.start();
        this.anim.join();
        node.setPaint(BinaryTreeNode2D.DEFAULT);
        this.anim = null;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.anim != null) {
            this.anim.interrupt();
        }
        this.anim = null;
        this.tempNode = null;
    }

    @Override
    public void paintStructure(Graphics2D g2D) {
        if (this.root != null) {
            this.root.paint(g2D);
        }
        if (this.tempNode != null) {
            this.tempNode.paint(g2D);
        }
    }

    @Override
    protected void processTreeUnsupported() throws InterruptedException {
        this.loadStructure();
    }

    @Override
    protected void processUpdateTree() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        this.animateTree();
        this.loadStructure();
        node = BinaryTreeNode2D.getNode(this.root, id);
        if (node != null && action.getSubscribe().length() > 15 && action.getSubscribe().substring(15).equals(node.getName())) {
            this.animateSide(node, 5);
            this.animateSide(node, -10);
            this.animateSide(node, 5);
        }
    }

    @Override
    protected void processVisitNode() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        this.animateTree();
        node = BinaryTreeNode2D.getNode(this.root, id);
        if (node != null) {
            node.blink(this.viewer.getPauseInterval(), colorSet, this.viewer);
        }
    }

    @Override
    protected void processVisitBranch() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        if (node != null) {
            ComplexNode2D temp = new ComplexNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
            temp.setName(action.getSubscribe().substring(7));
            ComplexNode2D dest = action.getActionType().substring(action.getActionType().length() - 1).equals("0") ? new ComplexNode2D((int)node.getLeftChild().getX() + AnimatedKey.DISTANCE, (int)node.getLeftChild().getY()) : new ComplexNode2D((int)node.getRightChild().getX() + AnimatedKey.DISTANCE, (int)node.getRightChild().getY());
            this.animate(temp, temp, dest);
            if (node.getRightChild().getName().equals(temp.getName()) || node.getLeftChild().getName().equals(temp.getName())) {
                this.tempNode = temp;
                this.animateSide(temp, -AnimatedKey.DISTANCE);
                this.tempNode = null;
            }
        }
    }

    @Override
    protected void processInsertNode() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        this.animateTree();
        node = BinaryTreeNode2D.getNode(this.root, id);
        if (node.getRightChild() != null) {
            ComplexNode2D temp = new ComplexNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
            temp.setName("NYT");
            BSTNodeVisibility.getInstance().makeInvisible(node.getRightChild());
            BSTNodeVisibility.getInstance().makeInvisible(node.getLeftChild());
            this.animate(temp, temp, (ComplexNode2D)node.getLeftChild());
            BSTNodeVisibility.getInstance().makeVisible(node.getLeftChild());
            temp = new ComplexNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
            temp.setName(node.getRightChild().getName());
            this.animate(temp, temp, (ComplexNode2D)node.getRightChild());
            BSTNodeVisibility.getInstance().makeVisible(node.getRightChild());
            node = node.getRightChild();
            this.animateSide(node, 5);
            this.animateSide(node, -10);
            this.animateSide(node, 5);
        }
    }

    @Override
    protected void processUnsupportedAction() {
    }

    public void animateTree() throws InterruptedException {
        int i;
        ActBST currentAct = (ActBST)this.getCurrentAction();
        int ind = this.actions.indexOf(this.getCurrentAction());
        ActBST previousAct = (ActBST)this.actions.get(ind - 1);
        LinkedList<ComplexNode2D> currentTree = this.makeTreeFromAction(currentAct);
        LinkedList<ComplexNode2D> previousTree = this.makeTreeFromAction(previousAct);
        AnimatedKey[] animArray = new AnimatedKey[currentTree.size()];
        for (i = 0; i < currentTree.size(); ++i) {
            animArray[i] = new AnimatedKey(this);
        }
        if (previousTree.size() > 0) {
            this.root = previousTree.getFirst();
        }
        AnimatedKey.PAUSE = this.viewer.getPauseInterval() / 20;
        for (i = 0; i < currentTree.size(); ++i) {
            BinaryTreeNode2D from = null;
            BinaryTreeNode2D to = currentTree.get(i);
            for (int j = 0; j < previousTree.size(); ++j) {
                if (previousTree.get(j).getId() != currentTree.get(i).getId()) continue;
                from = previousTree.get(j);
            }
            if (from == null) continue;
            animArray[i].setNewKey(from);
            animArray[i].setParameters(from, to);
            animArray[i].start();
        }
        for (i = 0; i < currentTree.size(); ++i) {
            animArray[i].join();
        }
        if (currentTree.size() > 0) {
            this.root = currentTree.getFirst();
        }
    }

    public LinkedList<ComplexNode2D> makeTreeFromAction(ActBST act) {
        ObservabileBinaryTree tree = (ObservabileBinaryTree)act.getStructs()[0];
        LinkedList<ObservabileBinaryTree.Node> tmp = new LinkedList<ObservabileBinaryTree.Node>();
        LinkedList<ComplexNode2D> nodes = new LinkedList<ComplexNode2D>();
        tree.BSTPreorder(tmp, tree.getRoot());
        for (ObservabileBinaryTree.Node n : tmp) {
            ComplexNode2D c = new ComplexNode2D(0, 0);
            c.setId(n.id);
            c.setName("" + n.value);
            if (n.genericAttributes.size() > 0 && n.genericAttributes.getFirst().value == -13) {
                c.setInfo(n.value);
                c.setName(n.genericAttributes.getFirst().id);
            }
            nodes.add(c);
        }
        if (nodes.size() > 0) {
            ((ComplexNode2D)nodes.getFirst()).setX(this.getWidth() / 2);
            ((ComplexNode2D)nodes.getFirst()).setY(this.getDy());
        }
        int h = tree.getHeight();
        for (int i = 0; i < tmp.size(); ++i) {
            int index = tmp.indexOf(tmp.get((int)i).left);
            ComplexNode2D current = nodes.get(i);
            ComplexNode2D temp = null;
            if (index != -1) {
                temp = nodes.get(index);
                temp.setX(current.getX() - (double)((int)Math.pow(2.0, h - tmp.get((int)index).level) * (this.getDx() + 5)));
                temp.setY(current.getY() + (double)this.getDy());
                current.setLeftChild(temp);
            }
            index = tmp.indexOf(tmp.get((int)i).right);
            temp = null;
            if (index == -1) continue;
            temp = nodes.get(index);
            temp.setX(current.getX() + (double)((int)Math.pow(2.0, h - tmp.get((int)index).level) * (this.getDx() + 5)));
            temp.setY(current.getY() + (double)this.getDy());
            current.setRightChild(temp);
        }
        return nodes;
    }

    @Override
    public String description() {
        return "Version: 1.0\n\nDescription:\nAnimated view for Dynamic \nHuffman algorithm\n\nAuthor: Dejan Mirosavljevi\u0107\n";
    }
}

