/*
 * Decompiled with CFR 0.152.
 */
package view.tree.binarySearchTree;

import action.ActBST;
import java.awt.Graphics2D;
import java.util.LinkedList;
import structure.ObservabileBinaryTree;
import view.BSTNodeVisibility;
import view.graphics.tree.AnimatedKey;
import view.graphics.tree.BinaryTreeNode2D;
import view.graphics.tree.ComplexNode2D;
import view.tree.AbstractBinaryTreeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSTAnimatedView
extends AbstractBinaryTreeView {
    protected AnimatedKey animatedKey = null;
    protected BinaryTreeNode2D tmpNode = null;
    protected BinaryTreeNode2D delNode = null;
    protected int criticNodePause = 1500;
    protected int originalPause = 150;

    public void addTmpNode(BinaryTreeNode2D tmp) {
        this.tmpNode = tmp;
    }

    public void removeTmpNode() {
        this.tmpNode = null;
    }

    public void setKeyDistance(int x) {
        AnimatedKey.DISTANCE = x;
        if (x > 0) {
            this.setTopLabel("Animated key position: Right");
        } else if (x < 0) {
            this.setTopLabel("Animated key position: Left");
        } else {
            this.setTopLabel("Animated key position: Center");
        }
    }

    public int getKeyDistance() {
        return AnimatedKey.DISTANCE;
    }

    @Override
    public void paintStructure(Graphics2D g2D) {
        if (this.root != null) {
            this.root.paint(g2D);
        }
        if (this.tmpNode != null) {
            this.tmpNode.paint(g2D);
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.animatedKey != null) {
            this.animatedKey.interrupt();
        }
        this.removeTmpNode();
    }

    public void animate(BinaryTreeNode2D from, BinaryTreeNode2D to) throws InterruptedException {
        AnimatedKey.PAUSE = this.viewer.getPauseInterval() / 20;
        this.animatedKey = new AnimatedKey(this);
        this.animatedKey.setNewKey(this.tmpNode);
        this.animatedKey.setParameters(from, to);
        if (!this.animatedKey.isCameraFollow()) {
            this.animatedKey.setCameraFollow(true);
        }
        this.animatedKey.start();
        this.animatedKey.join();
        this.animatedKey = null;
    }

    @Override
    protected void processTreeUnsupported() throws InterruptedException {
        this.loadStructure();
    }

    @Override
    protected void processUpdateTree() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        if (action.getActionType().length() > 22 && action.getActionType().substring(0, 22).equals("BST Search Failed for ")) {
            if (this.tmpNode != null && this.tmpNode.getName().equals(action.getActionType().substring(22))) {
                this.animate(this.tmpNode, new BinaryTreeNode2D((int)this.tmpNode.getX(), (int)this.tmpNode.getY() + 50));
                this.removeTmpNode();
                return;
            }
            this.removeTmpNode();
        }
        if (action.getActionType().length() > 10 && node != null && action.getActionType().substring(4, 10).equals("Delete") && action.getActionType().substring(11).equals(node.getName())) {
            this.tmpNode = new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
            this.tmpNode.setName(node.getName());
            this.animate(this.tmpNode, node);
            this.tmpNode = node;
            this.loadStructure();
            this.animate(this.tmpNode, new BinaryTreeNode2D((int)this.tmpNode.getX() + 5, (int)this.tmpNode.getY()));
            this.animate(this.tmpNode, new BinaryTreeNode2D((int)this.tmpNode.getX() - 10, (int)this.tmpNode.getY()));
            this.animate(this.tmpNode, new BinaryTreeNode2D((int)this.tmpNode.getX() + 10, (int)this.tmpNode.getY()));
            this.animate(this.tmpNode, new BinaryTreeNode2D((int)this.tmpNode.getX() - 5, (int)this.tmpNode.getY()));
            this.removeTmpNode();
        }
        if (id != -1) {
            if (action.getActionType().length() > 10 && action.getActionType().substring(0, 10).equals("BST Search") && action.getActionType().substring(11).equals(node.getName()) && AnimatedKey.DISTANCE != 0) {
                this.tmpNode = new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
                this.tmpNode.setName(node.getName());
                this.animate(node, node);
                this.removeTmpNode();
            }
            if (action.getActionType().length() > 15 && action.getActionType().substring(4, 15).equals("Replacement")) {
                if (node != null) {
                    node.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
                }
                this.removeTmpNode();
                return;
            }
            if (action.getActionType().length() > 10 && !action.getActionType().substring(0, 10).equals("BST Search") && !action.getActionType().substring(11).equals(node.getName())) {
                this.tmpNode = new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
                this.tmpNode.setName(action.getActionType().substring(11));
            }
            node.blink(this.viewer.getPauseInterval(), BinaryTreeNode2D.DEFAULT, this.viewer);
            if (this.tmpNode != null) {
                this.tmpNode.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
            }
        }
        if (this.isTreeChanged()) {
            if (this.viewer.getPauseInterval() == this.criticNodePause) {
                this.viewer.setPauseInterval(this.originalPause);
            }
            this.animateTree();
        } else if (action.getActionType().length() > 13 && (action.getActionType().substring(0, 14).equals("Right rotation") || action.getActionType().substring(0, 13).equals("Left rotation"))) {
            if (this.viewer.getPauseInterval() == this.criticNodePause) {
                this.viewer.setPauseInterval(this.originalPause);
            }
            this.animateTree();
        }
        this.loadStructure();
    }

    @Override
    protected void processVisitNode() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        if (action.getActionType().length() > 15 && action.getActionType().substring(4, 15).equals("Replacement")) {
            if (node != null) {
                node.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
            }
            this.removeTmpNode();
            return;
        }
        if (action.getActionType().length() > 10) {
            this.tmpNode = new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
            this.tmpNode.setName(action.getActionType().substring(11));
        }
        if (node != null) {
            node.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
        }
        if (this.tmpNode != null) {
            this.tmpNode.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
        }
    }

    @Override
    protected void processVisitBranch() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        String value = action.getActionType().substring(11);
        BinaryTreeNode2D animated = new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY());
        animated.setName(value);
        this.tmpNode = animated;
        int index = this.actions.indexOf(action);
        ActBST prev = null;
        if (index > 0) {
            prev = (ActBST)this.actions.get(index - 1);
        }
        if (action.getActionType().length() > 15 && action.getActionType().substring(4, 15).equals("Replacement")) {
            this.removeTmpNode();
            return;
        }
        if (id != prev.getID() && node != this.root) {
            this.tmpNode = new BinaryTreeNode2D((int)node.getParent().getX() + AnimatedKey.DISTANCE, (int)node.getParent().getY());
            this.tmpNode.setName(value);
            this.animate(this.tmpNode, new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY()));
        }
        this.removeTmpNode();
    }

    @Override
    protected void processInsertNode() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        if (this.isTreeChanged()) {
            this.animateTree();
        }
        int id = action.getID();
        BinaryTreeNode2D node = BinaryTreeNode2D.getNode(this.root, id);
        if (id != -1 && node == null) {
            return;
        }
        if (node == null) {
            BSTNodeVisibility.getInstance().makeInvisible(this.root);
            BinaryTreeNode2D temp = new BinaryTreeNode2D((int)this.root.getX() + AnimatedKey.DISTANCE, (int)this.root.getY());
            temp.setName(this.root.getName());
            this.addTmpNode(temp);
            this.animate(this.root, this.root);
            this.removeTmpNode();
            BSTNodeVisibility.getInstance().makeVisible(this.root);
            this.root.blink(this.viewer.getPauseInterval(), colorSet, this.viewer);
        } else {
            BinaryTreeNode2D temp;
            if (action.isLeft()) {
                temp = node.getLeftChild();
                temp.setName(node.getLeftChild().getName());
            } else {
                temp = node.getRightChild();
                temp.setName(node.getRightChild().getName());
            }
            BinaryTreeNode2D animated = new BinaryTreeNode2D((int)temp.getX() + AnimatedKey.DISTANCE, (int)temp.getY());
            animated.setName(temp.getName());
            this.addTmpNode(animated);
            BSTNodeVisibility.getInstance().makeInvisible(temp);
            this.animate(new BinaryTreeNode2D((int)node.getX() + AnimatedKey.DISTANCE, (int)node.getY()), temp);
            Thread.sleep(100L);
            this.addTmpNode(animated);
            this.animate(temp, temp);
            this.removeTmpNode();
            BSTNodeVisibility.getInstance().makeVisible(temp);
            if (action.isLeft()) {
                node.getLeftChild().blink(this.viewer.getPauseInterval(), colorSet, this.viewer);
            } else {
                node.getRightChild().blink(this.viewer.getPauseInterval(), colorSet, this.viewer);
            }
        }
    }

    @Override
    protected void processUnsupportedAction() {
    }

    @Override
    public void loadStructure() {
        if (this.viewer != null && this.viewer.getPauseInterval() == this.criticNodePause) {
            this.viewer.setPauseInterval(this.originalPause);
        }
        super.loadStructure();
        if (this.lookingForPause(this.root)) {
            this.originalPause = this.viewer.getPauseInterval();
            this.viewer.setPauseInterval(this.criticNodePause);
        }
    }

    public void animateTree() throws InterruptedException {
        int i;
        ActBST currentAct = (ActBST)this.getCurrentAction();
        int ind = this.actions.indexOf(this.getCurrentAction());
        ActBST previousAct = (ActBST)this.actions.get(ind - 1);
        LinkedList<BinaryTreeNode2D> currentTree = this.makeTreeFromAction(currentAct);
        LinkedList<BinaryTreeNode2D> previousTree = this.makeTreeFromAction(previousAct);
        AnimatedKey[] animArray = new AnimatedKey[currentTree.size()];
        for (i = 0; i < currentTree.size(); ++i) {
            animArray[i] = new AnimatedKey(this);
        }
        if (previousTree.size() > 0) {
            this.root = previousTree.getFirst();
        }
        AnimatedKey.PAUSE = this.viewer.getPauseInterval() / 20;
        this.removeTmpNode();
        for (i = 0; i < currentTree.size(); ++i) {
            BinaryTreeNode2D from = null;
            BinaryTreeNode2D to = currentTree.get(i);
            for (int j = 0; j < previousTree.size(); ++j) {
                if (previousTree.get(j).getId() != currentTree.get(i).getId()) continue;
                from = previousTree.get(j);
            }
            if (from == null) continue;
            animArray[i].setNewKey(from);
            animArray[i].setParameters(from, to);
            animArray[i].start();
        }
        for (i = 0; i < currentTree.size(); ++i) {
            animArray[i].join();
        }
        if (currentTree.size() > 0) {
            this.root = currentTree.getFirst();
        }
    }

    public boolean isTreeChanged() {
        ActBST current = (ActBST)this.getCurrentAction();
        int index = this.actions.indexOf(this.getCurrentAction());
        if (index <= 0) {
            return false;
        }
        ActBST previous = (ActBST)this.actions.get(index - 1);
        ObservabileBinaryTree currentTree = (ObservabileBinaryTree)current.getStructs()[0];
        ObservabileBinaryTree previousTree = (ObservabileBinaryTree)previous.getStructs()[0];
        if (currentTree.getHeight() != previousTree.getHeight()) {
            return true;
        }
        return current.getActionType().length() > 13 && (current.getActionType().substring(0, 13).equals("Left rotation") || current.getActionType().substring(0, 13).equals("Right rotation"));
    }

    public LinkedList<BinaryTreeNode2D> makeTreeFromAction(ActBST act) {
        ObservabileBinaryTree tree = (ObservabileBinaryTree)act.getStructs()[0];
        LinkedList<ObservabileBinaryTree.Node> tmp = new LinkedList<ObservabileBinaryTree.Node>();
        LinkedList<BinaryTreeNode2D> nodes = new LinkedList<BinaryTreeNode2D>();
        tree.BSTPreorder(tmp, tree.getRoot());
        for (ObservabileBinaryTree.Node n : tmp) {
            BinaryTreeNode2D c = new BinaryTreeNode2D(0, 0);
            c.setId(n.id);
            c.setName("" + n.value);
            nodes.add(c);
        }
        if (nodes.size() > 0) {
            ((BinaryTreeNode2D)nodes.getFirst()).setX(this.getWidth() / 2);
            ((BinaryTreeNode2D)nodes.getFirst()).setY(this.getDy());
        }
        int h = tree.getHeight();
        for (int i = 0; i < tmp.size(); ++i) {
            int index = tmp.indexOf(tmp.get((int)i).left);
            BinaryTreeNode2D current = nodes.get(i);
            BinaryTreeNode2D temp = null;
            if (index != -1) {
                temp = nodes.get(index);
                temp.setX(current.getX() - (double)((int)Math.pow(2.0, h - tmp.get((int)index).level) * (this.getDx() + 5)));
                temp.setY(current.getY() + (double)this.getDy());
                current.setLeftChild(temp);
            }
            index = tmp.indexOf(tmp.get((int)i).right);
            temp = null;
            if (index == -1) continue;
            temp = nodes.get(index);
            temp.setX(current.getX() + (double)((int)Math.pow(2.0, h - tmp.get((int)index).level) * (this.getDx() + 5)));
            temp.setY(current.getY() + (double)this.getDy());
            current.setRightChild(temp);
        }
        return nodes;
    }

    private void regulateView() {
        ActBST currentAct = (ActBST)this.getCurrentAction();
        LinkedList<BinaryTreeNode2D> tree = this.makeTreeFromAction(currentAct);
        System.out.println("Centar: " + this.getCenterX() + " " + this.getCenterY());
        System.out.println("Sirina - Visina: " + this.getWidth() + " " + this.getHeight());
        for (BinaryTreeNode2D n : tree) {
            if (n.getX() > (double)this.getWidth() / this.getZoom()) {
                while (n.getX() > (double)this.getWidth() / this.getZoom() / 2.0) {
                    System.out.println("X: " + n.getX() + " sirina/zoom: " + (double)this.getWidth() / this.getZoom() + " zoom:" + this.getZoom());
                    this.setZoom(this.getZoom() - 0.01);
                }
                double x = (double)this.getWidth() / this.getZoom() / 2.0 - this.root.getX();
                this.setCenterX((int)x);
                this.setCenterY(0);
                continue;
            }
            if (!(n.getX() / this.getZoom() < 0.0)) continue;
        }
    }

    @Override
    public String description() {
        return "Version: 1.0\n\nDescription:\nAn improved binary tree view \nthat can interpret and animate actions \ngenerated by the BST or AVL tree\n\nAuthor: Mirosavljevi\u0107 Dejan\n";
    }

    public boolean lookingForPause(BinaryTreeNode2D node) {
        ComplexNode2D compl;
        if (node == null) {
            return false;
        }
        if (ComplexNode2D.class.isInstance(node) && ((compl = (ComplexNode2D)node).getInfo().equals("-2") || compl.getInfo().equals("2"))) {
            return true;
        }
        if (this.lookingForPause(node.getLeftChild())) {
            return true;
        }
        return this.lookingForPause(node.getRightChild());
    }
}

