/*
 * Decompiled with CFR 0.152.
 */
package view.tree.bTree;

import java.awt.Graphics2D;
import java.util.LinkedList;
import structure.ObservabileBTree;
import view.graphics.tree.BTreeNode2D;
import view.tree.binarySearchTree.BinaryTreeView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeView
extends BinaryTreeView {
    BTreeNode2D broot;

    @Override
    public void paintStructure(Graphics2D g2D) {
        if (this.broot != null) {
            this.broot.paint(g2D);
        }
    }

    @Override
    public void loadStructure() {
        if (this.getCurrentAction() == null) {
            return;
        }
        ObservabileBTree tree = (ObservabileBTree)this.getCurrentAction().getStructs()[0];
        LinkedList<ObservabileBTree.BNode> tmp = new LinkedList<ObservabileBTree.BNode>();
        tree.TreeToList(tmp, tree.getBRoot());
        LinkedList<BTreeNode2D> nodes = new LinkedList<BTreeNode2D>();
        for (ObservabileBTree.BNode n : tmp) {
            BTreeNode2D c = new BTreeNode2D(0, 0);
            LinkedList<String> elems = new LinkedList<String>();
            c.setId(n.id);
            for (int i = 0; i < n.size; ++i) {
                String el = Integer.toString(n.value[i]);
                elems.add(el);
            }
            c.setElements(elems);
            nodes.add(c);
        }
        if (nodes.size() > 0) {
            this.broot = (BTreeNode2D)nodes.getFirst();
            this.broot.setX(this.getWidth() / 2);
            this.broot.setY(this.getDy());
        } else {
            this.broot = null;
        }
        int h = tree.getHeight();
        for (int i = 0; i < tmp.size(); ++i) {
            BTreeNode2D current = (BTreeNode2D)nodes.get(i);
            for (int j = 0; j < tmp.get((int)i).child.length; ++j) {
                int index = tmp.indexOf(tmp.get((int)i).child[j]);
                BTreeNode2D temp = null;
                if (index == -1) continue;
                temp = (BTreeNode2D)nodes.get(index);
                temp.setY(current.getY() + (double)this.getDy());
                temp.setX(this.findXCoord(index, tmp));
                current.setChild(temp);
            }
            this.viewer.repaint();
        }
    }

    private double findXCoord(int index, LinkedList<ObservabileBTree.BNode> structNodes) {
        ObservabileBTree.BNode snode = structNodes.get(index);
        int num = 0;
        int ind = 0;
        for (int i = 0; i < structNodes.size(); ++i) {
            if (!structNodes.get(i).equals(snode)) {
                ++num;
                continue;
            }
            ind = num++;
        }
        double x = this.broot.getX() - (double)(ObservabileBTree.nodeSize * BTreeNode2D.getR() * num);
        return x += (double)(ObservabileBTree.nodeSize * BTreeNode2D.getR() * ind * 2);
    }

    @Override
    public String description() {
        return "Version: 1.0\n\nDescription:\nB tree view\n\nAuthor: Dejan Mirosavljevi\u0107\n";
    }
}

