/*
 * Decompiled with CFR 0.152.
 */
package view.tree;

import action.ActBST;
import java.awt.Graphics2D;
import java.util.LinkedList;
import structure.ObservabileAVLTree;
import structure.ObservabileBinaryTree;
import structure.ObservabileVariable;
import view.AbstractView;
import view.graphics.graph.Node2D;
import view.graphics.tree.BinaryTreeNode2D;
import view.graphics.tree.ComplexNode2D;

public abstract class AbstractBinaryTreeView
extends AbstractView {
    protected BinaryTreeNode2D root;
    private int dy = 70;
    private int dx = 20;

    public void paintAbstract(Graphics2D g2D) {
        g2D.setRenderingHints(HINTS);
        this.paintStructure(g2D);
    }

    public void paintStructure(Graphics2D g2D) {
        if (this.root != null) {
            this.root.paint(g2D);
        }
    }

    public ObservabileVariable[] getCurrentStructures() {
        if (this.currentAction != null) {
            return this.currentAction.getStructs();
        }
        return null;
    }

    protected void additionalActionsNext() {
        this.loadStructure();
    }

    protected void additionalActionsPrevious() {
        this.loadStructure();
    }

    public void processCurrentAction(int pause) throws InterruptedException {
        super.processCurrentAction(pause);
        this.processing = true;
        if (this.getCurrentAction() instanceof ActBST) {
            this.processTreeAction();
        } else {
            this.processUnsupportedAction();
        }
        Thread.sleep(pause);
        this.processing = false;
    }

    protected void processTreeAction() throws InterruptedException {
        ActBST action = (ActBST)this.getCurrentAction();
        this.setBottomLabel(action.getActionType());
        switch (action.getType()) {
            case 6: {
                try {
                    this.loadStructure();
                }
                catch (Error error) {}
                break;
            }
            case 5: {
                this.processVisitBranch();
                break;
            }
            case 2: {
                this.processInsertNode();
                break;
            }
            case 4: {
                this.processUpdateTree();
                break;
            }
            case 0: {
                this.processVisitNode();
                break;
            }
            default: {
                this.processTreeUnsupported();
            }
        }
    }

    protected void visitBranch(BinaryTreeNode2D node) throws InterruptedException {
        BinaryTreeNode2D parent = node.getParent();
        int pause = this.viewer.getPauseInterval();
        if (parent != null) {
            if (node.getParent().isLeftChild(node)) {
                parent.getLeftBranch().blink(pause, colorGet, this.viewer);
            } else if (node.getParent().isRightChild(node)) {
                parent.getRightBranch().blink(pause, colorGet, this.viewer);
            }
        }
    }

    public void loadStructure() {
        if (this.getCurrentAction() == null) {
            return;
        }
        ObservabileBinaryTree tree = ObservabileBinaryTree.class.isInstance(this.getCurrentAction().getStructs()[0]) ? (ObservabileBinaryTree)this.getCurrentAction().getStructs()[0] : (ObservabileAVLTree)this.getCurrentAction().getStructs()[0];
        LinkedList<ObservabileBinaryTree.Node> tmp = new LinkedList<ObservabileBinaryTree.Node>();
        tree.BSTPreorder(tmp, tree.getRoot());
        LinkedList<ComplexNode2D> nodes = new LinkedList<ComplexNode2D>();
        for (ObservabileBinaryTree.Node n : tmp) {
            ComplexNode2D c = new ComplexNode2D(0, 0);
            c.setId(n.id);
            c.setName("" + n.value);
            if (n.genericAttributes.size() > 0) {
                if (n.genericAttributes.getFirst().value == -13) {
                    c.setInfo(n.value);
                    c.setName(n.genericAttributes.getFirst().id);
                } else {
                    c.setInfo(n.genericAttributes.getFirst().value);
                    if (n.genericAttributes.getFirst().value == 2 || n.genericAttributes.getFirst().value == -2) {
                        c.setPaint(Node2D.RED);
                    }
                }
            }
            switch (n.status) {
                case PARENT: {
                    c.setPaint(Node2D.BLUE);
                    break;
                }
                case REPLACEMENT: {
                    c.setPaint(Node2D.RED);
                    break;
                }
                case SEEN: 
                case CURRENT: {
                    c.setPaint(Node2D.GREEN);
                }
            }
            nodes.add(c);
        }
        if (nodes.size() > 0) {
            this.root = (BinaryTreeNode2D)nodes.getFirst();
            this.root.setX(this.getWidth() / 2);
            this.root.setY(this.dy);
        } else {
            this.root = null;
        }
        int h = tree.getHeight();
        for (int i = 0; i < tmp.size(); ++i) {
            int index = tmp.indexOf(tmp.get((int)i).left);
            ComplexNode2D current = (ComplexNode2D)nodes.get(i);
            ComplexNode2D temp = null;
            if (index != -1) {
                temp = (ComplexNode2D)nodes.get(index);
                temp.setX(current.getX() - (double)((int)Math.pow(2.0, h - tmp.get((int)index).level) * (this.dx + 5)));
                temp.setY(current.getY() + (double)this.dy);
                current.setLeftChild(temp);
            }
            index = tmp.indexOf(tmp.get((int)i).right);
            temp = null;
            if (index == -1) continue;
            temp = (ComplexNode2D)nodes.get(index);
            temp.setX(current.getX() + (double)((int)Math.pow(2.0, h - tmp.get((int)index).level) * (this.dx + 5)));
            temp.setY(current.getY() + (double)this.dy);
            current.setRightChild(temp);
        }
        this.viewer.repaint();
    }

    public BinaryTreeNode2D getRoot() {
        return this.root;
    }

    public void setRoot(BinaryTreeNode2D koren) {
        this.root = koren;
    }

    public int getDy() {
        return this.dy;
    }

    public void setDy(int dy) {
        this.dy = dy;
    }

    public int getDx() {
        return this.dx;
    }

    public void setDx(int dx) {
        this.dx = dx;
    }

    protected abstract void processInsertNode() throws InterruptedException;

    protected abstract void processUnsupportedAction() throws InterruptedException;

    protected abstract void processTreeUnsupported() throws InterruptedException;

    protected abstract void processUpdateTree() throws InterruptedException;

    protected abstract void processVisitNode() throws InterruptedException;

    protected abstract void processVisitBranch() throws InterruptedException;
}

