/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.tree;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import view.BSTNodeVisibility;
import view.graphics.tree.BinaryTreeNode2D;

public class ComplexNode2D
extends BinaryTreeNode2D {
    private String info = "";

    public ComplexNode2D(int x, int y) {
        super(x, y);
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setInfo(int value) {
        this.info = Integer.toString(value);
    }

    public ComplexNode2D getParent() {
        return (ComplexNode2D)super.getParent();
    }

    public ComplexNode2D getLeftChild() {
        return (ComplexNode2D)super.getLeftChild();
    }

    public ComplexNode2D getRightChild() {
        return (ComplexNode2D)super.getRightChild();
    }

    public void paint(Graphics2D g2D) {
        if (BSTNodeVisibility.getInstance().isVisible(this)) {
            AffineTransform old = g2D.getTransform();
            AffineTransform tf = new AffineTransform();
            tf.translate(this.getX(), this.getY());
            g2D.transform(tf);
            GradientPaint paint = (GradientPaint)this.getPaint();
            g2D.setPaint(paint);
            g2D.fill(this.getCircle());
            g2D.setPaint(Color.BLACK);
            this.drawCenteredString(g2D, this.getName());
            g2D.draw(this);
            if (!this.info.equals("")) {
                g2D.setPaint(paint);
                Rectangle2D.Double rect = new Rectangle2D.Double(-1.5 * (double)ComplexNode2D.getR(), -1.5 * (double)ComplexNode2D.getR(), 1.5 * (double)ComplexNode2D.getR(), ComplexNode2D.getR());
                g2D.fill(rect);
                g2D.setPaint(Color.black);
                g2D.draw(rect);
                tf.translate(-this.getX() - 0.7 * (double)ComplexNode2D.getR(), -this.getY() - (double)ComplexNode2D.getR());
                g2D.transform(tf);
                this.drawCenteredString(g2D, this.info);
            }
            g2D.setTransform(old);
        }
        if (this.getLeftChild() != null && BSTNodeVisibility.getInstance().isVisible(this.getLeftChild())) {
            if (BSTNodeVisibility.getInstance().getShowBranches()) {
                this.getLeftBranch().draw(g2D);
            }
            this.getLeftChild().paint(g2D);
        }
        if (this.getRightChild() != null && BSTNodeVisibility.getInstance().isVisible(this.getRightChild())) {
            if (BSTNodeVisibility.getInstance().getShowBranches()) {
                this.getRightBranch().draw(g2D);
            }
            this.getRightChild().paint(g2D);
        }
    }
}

