/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.tree;

import java.awt.Graphics2D;
import view.BSTNodeVisibility;
import view.graphics.graph.Branch2D;
import view.graphics.graph.Node2D;

public class BinaryTreeNode2D
extends Node2D {
    private int id;
    private Branch2D leftBranch;
    private Branch2D rightBranch;
    private BinaryTreeNode2D parent;
    private BinaryTreeNode2D leftChild;
    private BinaryTreeNode2D rightChild;

    public BinaryTreeNode2D(int x, int y) {
        super(x, y);
    }

    public static BinaryTreeNode2D getNode(BinaryTreeNode2D root, int id) {
        if (root == null) {
            return null;
        }
        if (root.id == id) {
            return root;
        }
        BinaryTreeNode2D ret = BinaryTreeNode2D.getNode(root.leftChild, id);
        if (ret != null) {
            return ret;
        }
        return BinaryTreeNode2D.getNode(root.rightChild, id);
    }

    public void paint(Graphics2D g2D) {
        if (BSTNodeVisibility.getInstance().isVisible(this)) {
            super.paint(g2D);
        }
        if (this.leftChild != null && BSTNodeVisibility.getInstance().isVisible(this.leftChild)) {
            if (BSTNodeVisibility.getInstance().getShowBranches()) {
                this.getLeftBranch().draw(g2D);
            }
            this.leftChild.paint(g2D);
        }
        if (this.rightChild != null && BSTNodeVisibility.getInstance().isVisible(this.rightChild)) {
            if (BSTNodeVisibility.getInstance().getShowBranches()) {
                this.getRightBranch().draw(g2D);
            }
            this.rightChild.paint(g2D);
        }
    }

    public BinaryTreeNode2D getLeftChild() {
        return this.leftChild;
    }

    public boolean isLeftChild(BinaryTreeNode2D node) {
        if (this.leftChild == null) {
            return false;
        }
        return this.leftChild.equals(node);
    }

    public boolean isRightChild(BinaryTreeNode2D node) {
        if (this.rightChild == null) {
            return false;
        }
        return this.rightChild.equals(node);
    }

    public void setLeftChild(BinaryTreeNode2D leftChild) {
        this.leftChild = leftChild;
        leftChild.parent = this;
        if (this.getLeftBranch() == null) {
            this.leftBranch = new Branch2D(this, leftChild, "");
            this.getLeftBranch().setBidirectional(true);
        } else {
            this.getLeftBranch().setTo(leftChild);
        }
    }

    public BinaryTreeNode2D getRightChild() {
        return this.rightChild;
    }

    public void setRightChild(BinaryTreeNode2D rightChild) {
        this.rightChild = rightChild;
        rightChild.parent = this;
        if (this.getRightBranch() == null) {
            this.rightBranch = new Branch2D(this, rightChild, "");
            this.getRightBranch().setBidirectional(true);
        } else {
            this.getRightBranch().setTo(rightChild);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return this.getName();
    }

    public BinaryTreeNode2D getParent() {
        return this.parent;
    }

    public void setParent(BinaryTreeNode2D parent) {
        this.parent = parent;
    }

    public Branch2D getLeftBranch() {
        return this.leftBranch;
    }

    public Branch2D getRightBranch() {
        return this.rightBranch;
    }
}

