/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.tree;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import view.BSTNodeVisibility;
import view.graphics.graph.Branch2D;
import view.graphics.tree.BinaryTreeNode2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeNode2D
extends BinaryTreeNode2D {
    private LinkedList<String> values = new LinkedList();
    private LinkedList<Branch2D> branches = new LinkedList();
    private LinkedList<BTreeNode2D> children = new LinkedList();

    public BTreeNode2D(int x, int y) {
        super(x, y);
    }

    @Override
    public BTreeNode2D getParent() {
        return (BTreeNode2D)super.getParent();
    }

    @Override
    public BTreeNode2D getLeftChild() {
        return (BTreeNode2D)super.getLeftChild();
    }

    @Override
    public BTreeNode2D getRightChild() {
        return (BTreeNode2D)super.getRightChild();
    }

    @Override
    public void paint(Graphics2D g2D) {
        if (BSTNodeVisibility.getInstance().isVisible(this)) {
            AffineTransform old = g2D.getTransform();
            AffineTransform tf = new AffineTransform();
            tf.translate(this.getX(), this.getY());
            g2D.transform(tf);
            GradientPaint paint = (GradientPaint)this.getPaint();
            g2D.setPaint(paint);
            g2D.fill(this.getCircle());
            g2D.setPaint(Color.BLACK);
            g2D.draw(this);
            for (int i = 0; i < this.values.size(); ++i) {
                AffineTransform temp = g2D.getTransform();
                double x = this.getXPosition(i);
                g2D.setPaint(Color.white);
                Rectangle2D.Double rect = new Rectangle2D.Double(x, -0.5 * (double)BTreeNode2D.getR(), 1.5 * (double)BTreeNode2D.getR(), BTreeNode2D.getR());
                g2D.fill(rect);
                g2D.setPaint(Color.black);
                g2D.draw(rect);
                tf.translate(-this.getX() + x + 0.75 * (double)BTreeNode2D.getR(), -this.getY());
                g2D.transform(tf);
                tf.translate(this.getX() - x - 0.75 * (double)BTreeNode2D.getR(), this.getY());
                this.drawCenteredString(g2D, this.values.get(i));
                g2D.setTransform(temp);
            }
            g2D.setTransform(old);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).paint(g2D);
        }
    }

    private double getXPosition(int pos) {
        double x = this.values.size() % 2 != 0 ? -0.75 * (double)BTreeNode2D.getR() - 1.5 * (double)(this.values.size() / 2) * (double)BTreeNode2D.getR() + (double)pos * 1.5 * (double)BTreeNode2D.getR() : -1.5 * (double)(this.values.size() / 2) * (double)BTreeNode2D.getR() + (double)pos * 1.5 * (double)BTreeNode2D.getR();
        return x;
    }

    public void setElements(LinkedList<String> elems) {
        this.values = elems;
    }

    public void setChild(BTreeNode2D n) {
        this.children.add(n);
    }
}

