/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.tree;

import java.awt.Graphics2D;
import java.util.LinkedList;
import structure.ObservabileBTree;
import view.graphics.array.Element;
import view.graphics.graph.Branch2D;
import view.graphics.graph.Node2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BNode2D
extends Node2D {
    private int id;
    private LinkedList<Element> elements = new LinkedList();
    private LinkedList<BNode2D> children = new LinkedList();
    private LinkedList<Branch2D> branches = new LinkedList();

    public BNode2D(int x, int y) {
        super(x, y);
    }

    public void setChild(BNode2D node) {
        this.children.add(node);
    }

    public void setChildrenXPositions() {
        int ns = ObservabileBTree.nodeSize * Element.getA();
        int x = (int)(this.getX() - (double)(ns * this.children.size() / 2));
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setX(x);
            x += ns;
        }
    }

    public void createBranches() {
        for (int i = 0; i < this.children.size(); ++i) {
            Node2D from = new Node2D((int)(this.getX() + (double)(Element.getA() * i)), (int)this.getY());
            Node2D to = new Node2D((int)this.children.get(i).getX(), (int)this.children.get(i).getY());
            Branch2D branch = new Branch2D(from, to, "");
            this.branches.add(branch);
        }
    }

    public void addElement(Element e) {
        this.elements.add(e);
    }

    public void addChild(BNode2D node) {
        this.children.add(node);
    }

    public void addBranch(Element e, BNode2D node) {
    }

    public LinkedList<Branch2D> getBranches() {
        return this.branches;
    }

    public void setBranches(LinkedList<Branch2D> branches) {
        this.branches = branches;
    }

    public LinkedList<Element> getElements() {
        return this.elements;
    }

    public void setElements(LinkedList<Element> elements) {
        this.elements = elements;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void paint(Graphics2D g2D) {
        int i;
        this.setChildrenXPositions();
        this.createBranches();
        for (i = 0; i < this.branches.size(); ++i) {
            this.branches.get(i).draw(g2D);
        }
        for (i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setX((int)(this.getX() + (double)(Element.getA() * i)));
            this.elements.get(i).setY((int)this.getY());
            this.elements.get(i).paint(g2D);
        }
        for (i = 0; i < this.children.size(); ++i) {
            this.children.get(i).paint(g2D);
        }
    }

    public LinkedList<BNode2D> getChildren() {
        return this.children;
    }
}

