/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.tree;

import java.io.Serializable;
import view.AbstractView;
import view.graphics.tree.BinaryTreeNode2D;

public class AnimatedKey
extends Thread
implements Serializable {
    protected BinaryTreeNode2D newKey;
    protected AbstractView view;
    protected BinaryTreeNode2D from;
    protected BinaryTreeNode2D to;
    protected boolean cameraFollow = false;
    public static int INCREMENT = 1;
    public static int DISTANCE = 30;
    public static long PAUSE = 5L;
    public static final int KEY_POSITION_LEFT = -30;
    public static final int KEY_POSITION_CENTER = 0;
    public static final int KEY_POSITION_RIGHT = 30;

    public AnimatedKey(AbstractView view) {
        this.view = view;
    }

    public void setParameters(BinaryTreeNode2D from, BinaryTreeNode2D to) {
        this.interrupt();
        this.from = from;
        this.to = to;
    }

    private void moveKey(BinaryTreeNode2D node, double x, double y) {
        node.setX(x);
        node.setY(y);
        this.view.getViewer().repaint();
    }

    public void run() {
        try {
            int dy = INCREMENT;
            if (Math.abs(this.from.getX() - this.to.getX()) > 100.0) {
                dy = 2;
            }
            if (Math.abs(this.from.getX() - this.to.getX()) > 200.0) {
                dy = 3;
            }
            if (Math.abs(this.from.getX() - this.to.getX()) > 300.0) {
                dy = 5;
            }
            if (this.from.getY() == this.to.getY()) {
                if (this.newKey.getX() > this.to.getX()) {
                    for (double i = this.newKey.getX(); i >= this.to.getX(); i -= (double)dy) {
                        this.moveKey(this.newKey, i, this.newKey.getY());
                        Thread.sleep(PAUSE * 3L);
                    }
                } else {
                    for (double i = this.newKey.getX(); i <= this.to.getX(); i += (double)dy) {
                        this.moveKey(this.newKey, i, this.newKey.getY());
                        Thread.sleep(PAUSE * 3L);
                    }
                }
            } else if (this.from.getX() == this.to.getX()) {
                if (this.newKey.getY() > this.to.getY()) {
                    for (double i = this.newKey.getY(); i >= this.to.getY(); i -= (double)dy) {
                        this.moveKey(this.newKey, this.newKey.getX(), i);
                        Thread.sleep(PAUSE * 3L);
                    }
                } else {
                    for (double i = this.newKey.getY(); i <= this.to.getY(); i += (double)dy) {
                        this.moveKey(this.newKey, this.newKey.getX(), i);
                        Thread.sleep(PAUSE * 3L);
                    }
                }
            } else if (this.newKey != null) {
                for (double t = 0.0; t < 1.0; t += 0.02) {
                    double x = this.to.getX() * t + this.from.getX() * (1.0 - t);
                    double y = this.to.getY() * t + this.from.getY() * (1.0 - t);
                    this.moveKey(this.newKey, x, y);
                    Thread.sleep(PAUSE * 3L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public BinaryTreeNode2D getNewKey() {
        return this.newKey;
    }

    public void setNewKey(BinaryTreeNode2D newNode) {
        this.newKey = newNode;
    }

    public static int getDISTANCE() {
        return DISTANCE;
    }

    public static void setDISTANCE(int DISTANCE) {
        AnimatedKey.DISTANCE = DISTANCE;
    }

    public boolean isCameraFollow() {
        return this.cameraFollow;
    }

    public void setCameraFollow(boolean cameraFollow) {
        this.cameraFollow = cameraFollow;
    }
}

