/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.graph;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JPanel;
import view.graphics.MyGraphicElem;

public class Node2D
extends MyGraphicElem
implements Shape,
Serializable {
    private double x;
    private double y;
    private String name;
    private boolean selected;
    private Ellipse2D circle;
    private Color c1 = DEFAULT.getColor1();
    private Color c2 = DEFAULT.getColor2();
    private static int r = 18;
    public static final GradientPaint DEFAULT = new GradientPaint(-r, 0.0f, new Color(220, 220, 220), r, r, new Color(0, 20, 50));
    public static final GradientPaint GREEN = new GradientPaint(-r, 0.0f, new Color(200, 200, 200), r, r, new Color(0, 80, 20));
    public static final GradientPaint RED = new GradientPaint(-r, 0.0f, new Color(200, 200, 200), r, r, new Color(120, 20, 0));
    public static final GradientPaint BLUE = new GradientPaint(-r, 0.0f, new Color(200, 200, 200), r, r, new Color(0, 30, 120));

    public Node2D(int x, int y) {
        this.x = x;
        this.y = y;
        this.circle = new Ellipse2D.Double(-r, -r, 2 * r, 2 * r);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Paint getPaint() {
        return new GradientPaint(-r, 0.0f, this.c1, r, r, this.c2);
    }

    public void setPaint(Paint paint) {
        if (paint instanceof GradientPaint) {
            this.c1 = ((GradientPaint)paint).getColor1();
            this.c2 = ((GradientPaint)paint).getColor2();
        } else if (paint instanceof Color) {
            this.c1 = this.c2 = (Color)paint;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Rectangle getBounds() {
        return this.circle.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.circle.getBounds2D();
    }

    public boolean contains(double x, double y) {
        return this.circle.contains(this.x - x, this.y - y);
    }

    public boolean contains(Point2D p) {
        double tmpX = this.x - p.getX();
        double tmpY = this.y - p.getY();
        p.setLocation(tmpX, tmpY);
        return this.circle.contains(p);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.circle.intersects(this.x - x, this.y - y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        double tmpX = this.x - r.getX();
        double tmpY = this.y - r.getY();
        r.setRect(tmpX, tmpY, r.getWidth(), r.getHeight());
        return this.circle.intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.circle.contains(this.x - x, this.y - y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        double tmpX = this.x - r.getX();
        double tmpY = this.y - r.getY();
        r.setRect(tmpX, tmpY, r.getWidth(), r.getHeight());
        return this.circle.contains(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.circle.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.circle.getPathIterator(at, flatness);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node2D)) {
            return false;
        }
        Node2D c = (Node2D)o;
        return this.name.equals(c.name);
    }

    private void blinkOnce(int pause, Paint boja, JPanel prikazivac) throws InterruptedException {
        Paint stara = this.getPaint();
        this.setPaint(boja);
        prikazivac.repaint();
        Thread.sleep(pause);
        this.setPaint(stara);
        prikazivac.repaint();
        Thread.sleep(pause);
    }

    public void blink(int pause, Paint boja, JPanel prikazivac) throws InterruptedException {
        this.blinkOnce(pause, boja, prikazivac);
        this.blinkOnce(pause, boja, prikazivac);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + r;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public void paint(Graphics2D g2D) {
        AffineTransform old = g2D.getTransform();
        AffineTransform tf = new AffineTransform();
        tf.translate(this.x, this.y);
        g2D.transform(tf);
        GradientPaint paint = new GradientPaint(-r, 0.0f, this.c1, r, r, this.c2);
        g2D.setPaint(paint);
        g2D.fill(this.circle);
        g2D.setPaint(Color.BLACK);
        this.drawCenteredString(g2D, this.name);
        g2D.draw(this);
        g2D.setTransform(old);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selektovan) {
        this.selected = selektovan;
    }

    public static int getR() {
        return r;
    }

    public static void setR(int aR) {
        r = aR;
    }

    public Ellipse2D getCircle() {
        return this.circle;
    }
}

