/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JPanel;
import view.graphics.MyGraphicElem;
import view.graphics.graph.Node2D;

public class Branch2D
extends MyGraphicElem
implements Shape,
Serializable {
    private String weight;
    private Node2D from;
    private Node2D to;
    private boolean bidirectional;
    private boolean selected;
    private Color color = Color.BLACK;
    private Point p1 = new Point();
    private Point p2 = new Point();
    private static int arrowWidth = 5;

    public Branch2D(Node2D from, Node2D to, String tezina) {
        this.to = to;
        this.from = from;
        this.weight = tezina;
    }

    public void draw(Graphics2D g2D) {
        this.update();
        Stroke old = g2D.getStroke();
        g2D.setPaint(this.color);
        g2D.setStroke(new BasicStroke(this.selected ? 2.5f : 1.0f));
        Line2D.Double linija = new Line2D.Double(this.p1, this.p2);
        g2D.draw(linija);
        this.drawBranchWeight(g2D);
        if (!this.bidirectional) {
            this.drawArrowHead(g2D);
        }
        g2D.setStroke(old);
    }

    public Rectangle getBounds() {
        this.update();
        return new Line2D.Double(this.p1, this.p2).getBounds();
    }

    public Rectangle2D getBounds2D() {
        this.update();
        return new Line2D.Double(this.p1, this.p2).getBounds2D();
    }

    public boolean contains(double x, double y) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).contains(x, y);
    }

    public boolean contains(Point2D p) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).contains(p);
    }

    public boolean intersects(double x, double y, double w, double h) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).contains(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        this.update();
        return new Line2D.Double(this.p1, this.p2).getPathIterator(at, flatness);
    }

    public void blink(int pause, Paint paint, JPanel viewer) throws InterruptedException {
        this.blinkOnce(pause, paint, viewer);
        this.blinkOnce(pause, paint, viewer);
    }

    public void blinkOnce(int pause, Paint paint, JPanel viewer) throws InterruptedException {
        Color old = this.color;
        boolean isSelected = this.selected;
        this.setColor(paint);
        this.setSelected(true);
        viewer.repaint();
        Thread.sleep(pause);
        this.setColor(old);
        this.setSelected(false);
        viewer.repaint();
        Thread.sleep(pause);
        this.setSelected(isSelected);
    }

    public Paint getColor() {
        return this.color;
    }

    public void setColor(Paint paint) {
        Color c = null;
        if (paint instanceof GradientPaint) {
            c = ((GradientPaint)paint).getColor1();
        } else if (paint instanceof Color) {
            c = (Color)paint;
        }
        this.color = c;
    }

    private void update() {
        double r = Node2D.getR();
        double x1 = this.from.getX();
        double y1 = this.from.getY();
        double x2 = this.to.getX();
        double y2 = this.to.getY();
        double x = x1;
        double y = y1;
        double k = this.calculateK(x1, y1, x2, y2);
        double n = this.calculateN(x1, y1, k);
        double sgn = Math.signum(y2 - y1);
        double len = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        y = x2 == x1 ? y - sgn * r : k * (x += (x2 - x1) * r / len) + n;
        x2 -= (x2 - x1) * r / len;
        y2 = x2 == x1 ? y2 - sgn * r : k * x2 + n;
        this.p1.setLocation(x, y);
        this.p2.setLocation(x2, y2);
    }

    private double calculateK(double x1, double y1, double x2, double y2) {
        return (y2 - y1) / (x2 - x1);
    }

    private double calculateN(double x, double y, double k) {
        return y - k * x;
    }

    private void drawBranchWeight(Graphics2D g2D) {
        if (this.weight.equals("")) {
            return;
        }
        double x1 = this.p1.getX();
        double y1 = this.p1.getY();
        double x2 = this.p2.getX();
        double y2 = this.p2.getY();
        double k = this.calculateK(x1, y1, x2, y2);
        double n = this.calculateN(x1, y1, k);
        double x = x2 - (x2 - x1) * 0.5;
        double y = x2 == x1 ? (y2 + y1) * 0.5 : k * x + n;
        AffineTransform old = g2D.getTransform();
        AffineTransform tf = new AffineTransform();
        FontRenderContext frc = g2D.getFontRenderContext();
        TextLayout layout = new TextLayout(this.weight, g2D.getFont(), frc);
        Rectangle2D bounds = layout.getBounds();
        int dx = (int)bounds.getWidth() / 2 + 2;
        int dy = (int)bounds.getHeight() / 2 + 2;
        if (x1 < x2) {
            x = y1 >= y2 ? (x -= (double)dx) : (x += (double)dx);
        } else if (x1 > x2) {
            x = y1 < y2 ? (x -= (double)dx) : (x += (double)dx);
        }
        if (x1 != x2) {
            y -= (double)dy;
        } else {
            x += (double)dx;
            y += (double)dy;
        }
        tf.translate(x, y);
        g2D.transform(tf);
        this.drawCenteredString(g2D, this.weight);
        g2D.setTransform(old);
    }

    private void drawArrowHead(Graphics2D g2D) {
        double x1 = this.p1.getX();
        double y1 = this.p1.getY();
        double x2 = this.p2.getX();
        double y2 = this.p2.getY();
        double k = this.calculateK(x1, y1, x2, y2);
        double n = this.calculateN(x1, y1, k);
        double len = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        double x = x2 - (x2 - x1) * 10.0 / len;
        double y = y2 - (y2 - y1) * 10.0 / len;
        double xa = x;
        double xb = x;
        double ya = y + (double)arrowWidth;
        double yb = y - (double)arrowWidth;
        if (k != 0.0) {
            k = -1.0 / k;
            n = this.calculateN(x, y, k);
            double a = k * k + 1.0;
            double b = 2.0 * (k * (n - y) - x);
            double c = (n - y) * (n - y) + x * x - (double)(arrowWidth * arrowWidth);
            xa = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            xb = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            ya = k * xa + n;
            yb = k * xb + n;
        }
        int[] xPoints = new int[]{(int)x2, (int)xa, (int)xb};
        int[] yPoints = new int[]{(int)y2, (int)ya, (int)yb};
        g2D.fillPolygon(xPoints, yPoints, 3);
    }

    public Node2D getFrom() {
        return this.from;
    }

    public void setFrom(Node2D from) {
        this.from = from;
    }

    public Node2D getTo() {
        return this.to;
    }

    public void setTo(Node2D to) {
        this.to = to;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

