/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.array;

import view.array.ArrayView;
import view.graphics.array.Animator;
import view.graphics.array.Element;

public class SwapAnimator
extends Animator {
    protected Element elem2;

    public SwapAnimator(ArrayView view) {
        super(view);
    }

    public void setParameters(Element from, Element to, int direction) {
        super.setParameters(from, to, direction);
        this.elem2 = new Element(to.getX(), to.getY(), to.getValue());
        this.view.addTempElement(this.elem2);
    }

    protected void interruptHappened() {
        super.interrupt();
        this.from.setValue(this.valueTo);
        this.to.setValue(this.valueFrom);
        this.view.getViewer().repaint();
    }

    protected void stepOne() throws InterruptedException {
        int dy = 2 * Element.getA();
        int num = Math.abs(this.from.getY() - this.to.getY() + 2 * Element.getA()) / INCREMENT;
        for (int i = 0; i < num; ++i) {
            this.moveYAxis(this.elem, this.elem.getY() + this.direction * INCREMENT, this.direction);
            this.moveYAxis(this.elem2, this.elem2.getY() - this.direction * INCREMENT, -this.direction);
            Thread.sleep(PAUSE);
        }
        this.moveYAxis(this.elem, this.from.getY() - dy, this.direction);
        this.moveYAxis(this.elem2, this.to.getY() + dy, -this.direction);
    }

    protected void stepTwo() throws InterruptedException {
        int smerX = (int)Math.signum(this.from.getX() - this.to.getX());
        int num = Math.abs(this.from.getX() - this.to.getX()) / INCREMENT;
        for (int i = 0; i < num; ++i) {
            this.moveXAxis(this.elem, this.elem.getX() - smerX * INCREMENT, -smerX, true);
            this.moveXAxis(this.elem2, this.elem2.getX() + smerX * INCREMENT, smerX, false);
            Thread.sleep(PAUSE);
        }
        this.moveXAxis(this.elem, this.to.getX(), -smerX, true);
        this.moveXAxis(this.elem2, this.from.getX(), smerX, false);
    }

    protected void stepThree() throws InterruptedException {
        int num = Math.abs(this.from.getY() - this.to.getY() + 2 * Element.getA()) / INCREMENT;
        for (int i = 0; i < num; ++i) {
            this.moveYAxis(this.elem, this.elem.getY() - this.direction * INCREMENT, -this.direction);
            this.moveYAxis(this.elem2, this.elem2.getY() + this.direction * INCREMENT, this.direction);
            Thread.sleep(PAUSE);
        }
        this.moveYAxis(this.elem, this.to.getY(), -this.direction);
        this.moveYAxis(this.elem2, this.from.getY(), this.direction);
    }
}

