/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.array;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.JPanel;
import view.graphics.MyGraphicElem;

public class Element
extends MyGraphicElem
implements Serializable {
    private int x;
    private int y;
    private Color myColor;
    private String value;
    private boolean selected;
    private transient RoundRectangle2D.Double rectangle;
    private static int a = 40;
    private static final Paint paint = new GradientPaint(-a / 2, a / 2, new Color(200, 200, 200), a / 2, -a / 2, new Color(0, 20, 50));

    public Element() {
        this(0, 0, "");
    }

    public Element(int x, int y, String vrednost) {
        this.x = x;
        this.y = y;
        this.value = vrednost;
        this.updateRect();
    }

    public void paint(Graphics2D g2D) {
        AffineTransform old = g2D.getTransform();
        AffineTransform tx = new AffineTransform();
        Paint oldPaint = g2D.getPaint();
        tx.translate(this.x, this.y);
        g2D.transform(tx);
        this.processSelection(g2D);
        this.updateRect();
        g2D.fill(this.rectangle);
        g2D.setPaint(Color.GRAY);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.draw(this.rectangle);
        g2D.setPaint(Color.WHITE);
        this.drawCenteredString(g2D, this.value);
        g2D.setPaint(oldPaint);
        g2D.setTransform(old);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String vrednost) {
        this.value = vrednost;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selektovan) {
        this.selected = selektovan;
    }

    public static int getA() {
        return a;
    }

    public static void setA(int aA) {
        a = aA;
    }

    public static Paint getBoja() {
        return paint;
    }

    public void updateRect() {
        this.rectangle = new RoundRectangle2D.Double(-a / 2, -a / 2, a, a, 10.0, 10.0);
    }

    public RoundRectangle2D.Double getRectangle() {
        return this.rectangle;
    }

    public void setRectangle(RoundRectangle2D.Double rectangle) {
        this.rectangle = rectangle;
    }

    public Paint getMyColor() {
        return this.myColor;
    }

    public void setMyColor(Color myColor) {
        this.myColor = myColor;
    }

    public void blink(int pause, Color color, JPanel viewer) throws InterruptedException {
        this.blinkOnce(pause, color, viewer);
        this.blinkOnce(pause, color, viewer);
    }

    protected void processSelection(Graphics2D g2D) {
        if (this.isSelected()) {
            g2D.setPaint(this.myColor);
        } else {
            g2D.setPaint(paint);
        }
    }

    protected void blinkOnce(int pause, Color color, JPanel viewer) throws InterruptedException {
        this.myColor = color;
        this.selected = true;
        viewer.repaint();
        Thread.sleep(pause);
        this.selected = false;
        viewer.repaint();
        Thread.sleep(pause);
    }
}

