/*
 * Decompiled with CFR 0.152.
 */
package view.graphics.array;

import java.awt.Paint;
import java.io.Serializable;
import view.array.ArrayView;
import view.graphics.array.Element;

public class Animator
extends Thread
implements Serializable {
    protected int direction;
    protected ArrayView view;
    protected Element from;
    protected Element to;
    protected Element elem;
    protected String valueFrom;
    protected String valueTo;
    protected static Paint paint;
    public static int INCREMENT;
    public static final int UP = -1;
    public static final int DOWN = 1;
    public static long PAUSE;

    public Animator(ArrayView view) {
        this.view = view;
    }

    public void setParameters(Element from, Element to, int direction) {
        this.interrupt();
        this.from = from;
        this.to = to;
        this.direction = direction;
        this.valueFrom = from.getValue();
        this.valueTo = to.getValue();
        this.elem = new Element(from.getX(), from.getY(), from.getValue());
        this.view.addTempElement(this.elem);
    }

    public void moveXAxis(Element elem, int x, int dx, boolean variable) throws InterruptedException {
        elem.setX(x);
        this.view.getViewer().repaint();
    }

    public void moveYAxis(Element elem, int y, int dy) throws InterruptedException {
        elem.setY(y);
        this.view.getViewer().repaint();
    }

    public void run() {
        try {
            this.stepOne();
            this.stepTwo();
            this.stepThree();
        }
        catch (InterruptedException e) {
            this.interruptHappened();
        }
    }

    public static Paint getBoja() {
        return paint;
    }

    public static void setBoja(Paint aBoja) {
        paint = aBoja;
    }

    protected void interruptHappened() {
        this.to.setValue(this.valueFrom);
    }

    protected void stepOne() throws InterruptedException {
        int dy = INCREMENT * this.direction;
        if (this.direction == -1) {
            int y = this.from.getY() - 2 * Element.getA();
            if (y < 40) {
                y = 40;
            }
            for (int i = this.from.getY(); i > y; i += dy) {
                this.moveYAxis(this.elem, i, dy);
                Thread.sleep(PAUSE);
            }
            this.moveYAxis(this.elem, y, dy);
        } else {
            int y = this.from.getY() + 2 * Element.getA();
            for (int i = this.from.getY(); i < y; i += dy) {
                this.moveYAxis(this.elem, i, dy);
                Thread.sleep(PAUSE);
            }
            this.moveYAxis(this.elem, y, dy);
        }
    }

    protected void stepTwo() throws InterruptedException {
        int dx = INCREMENT;
        if (this.from.getX() < this.to.getX()) {
            int x = this.to.getX();
            for (int i = this.from.getX(); i < x; i += dx) {
                this.moveXAxis(this.elem, i, dx, true);
                Thread.sleep(PAUSE);
            }
            this.moveXAxis(this.elem, x, dx, true);
        } else {
            int x = this.to.getX();
            for (int i = this.from.getX(); i > x; i -= dx) {
                this.moveXAxis(this.elem, i, -dx, true);
                Thread.sleep(PAUSE);
            }
            this.moveXAxis(this.elem, x, -dx, true);
        }
    }

    protected void stepThree() throws InterruptedException {
        int dy = -INCREMENT * this.direction;
        if (this.direction == -1) {
            int y = this.to.getY();
            int tmp = this.from.getY() - 2 * Element.getA();
            if (tmp < 40) {
                tmp = 40;
            }
            for (int i = tmp; i < y; i += dy) {
                this.moveYAxis(this.elem, i, dy);
                Thread.sleep(PAUSE);
            }
            this.moveYAxis(this.elem, y, dy);
        } else {
            int tmp;
            int y = this.to.getY();
            for (int i = tmp = this.from.getY() + 2 * Element.getA(); i > y; i += dy) {
                this.moveYAxis(this.elem, i, dy);
                Thread.sleep(PAUSE);
            }
            this.moveYAxis(this.elem, y, dy);
        }
    }

    static {
        INCREMENT = 1;
        PAUSE = 5L;
    }
}

