/*
 * Decompiled with CFR 0.152.
 */
package view.graph;

import action.ActGraph;
import java.awt.Color;
import structure.ObservabileGraph;
import view.graph.AbstractGraphView;
import view.graphics.graph.Branch2D;
import view.graphics.graph.Node2D;

public class GraphView
extends AbstractGraphView {
    protected void processGraphUnsupported() throws InterruptedException {
        this.loadStructure();
    }

    protected void processRefreshGraph() throws InterruptedException {
        this.loadStructure();
    }

    protected void processAccessNode() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        node1.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
    }

    protected void processAccessBranch() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        Node2D node2 = this.getNode(this.nodeB);
        Branch2D branch = this.getBranch(node1, node2);
        branch.blink(this.viewer.getPauseInterval(), colorAccess, this.viewer);
    }

    protected void processDeleteNode() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        if (node1.getPaint().equals(colorFinal)) {
            node1.setPaint(colorFinal);
        } else {
            node1.setPaint(colorDeselected);
        }
        this.viewer.repaint();
    }

    protected void processSelectNode() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        node1.blink(this.viewer.getPauseInterval(), colorDeselected, this.viewer);
        this.viewer.repaint();
    }

    protected void processSelectBranch() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        Node2D node2 = this.getNode(this.nodeB);
        Branch2D branch = this.getBranch(node1, node2);
        branch.blink(this.viewer.getPauseInterval(), colorSelected, this.viewer);
    }

    protected void processFinalNode() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        node1.blink(this.viewer.getPauseInterval(), colorDeselected, this.viewer);
        node1.setSelected(true);
        this.viewer.repaint();
    }

    protected void processFinalBranch() throws InterruptedException {
        Node2D node1 = this.getNode(this.nodeA);
        Node2D node2 = this.getNode(this.nodeB);
        Branch2D branch = this.getBranch(node1, node2);
        branch.setColor(Color.BLACK);
        branch.blink(this.viewer.getPauseInterval(), colorFinal, this.viewer);
        branch.setColor(colorFinal);
        branch.setSelected(true);
        this.viewer.repaint();
    }

    protected void processSetBranchWeight() throws InterruptedException {
        ActGraph action = (ActGraph)this.getCurrentAction();
        String[][] matrix = ((ObservabileGraph)action.getStructs()[0]).getWeightMatrix();
        Node2D node1 = this.getNode(this.nodeA);
        Node2D node2 = this.getNode(this.nodeB);
        Branch2D branch = this.getBranch(node1, node2);
        branch.blink(this.viewer.getPauseInterval(), colorSet, this.viewer);
        branch.setWeight(matrix[this.nodes.indexOf(node1)][this.nodes.indexOf(node2)]);
    }

    protected void processUnsupportedAction() {
    }

    public String description() {
        return "Version: 1.0\n\nDescription:\nA graph view that can interpret\nand animate actions generated by\nvarious graph algorithms.\nFor unknown actions only the current\nstructure state will be shown\n\nAuthor: Milo\u0161 Milivojevi\u0107\n";
    }
}

