/*
 * Decompiled with CFR 0.152.
 */
package view.graph;

import action.ActGraph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.LinkedList;
import structure.ObservabileGraph;
import view.AbstractView;
import view.graphics.graph.Branch2D;
import view.graphics.graph.Node2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphView
extends AbstractView {
    protected String nodeA;
    protected String nodeB;
    protected LinkedList<Node2D> nodes = new LinkedList();
    protected LinkedList<Branch2D> branches = new LinkedList();
    protected static Paint colorDeselected = Node2D.DEFAULT;
    protected static Color colorFinal = new Color(140, 20, 20);
    protected static Color colorFinalSelected = new Color(60, 40, 20);
    protected static Color colorAccess = new Color(150, 10, 150);

    public void setGraph(LinkedList<Node2D> nodes, LinkedList<Branch2D> branches) {
        this.nodes = nodes;
        this.branches = branches;
        colorDeselected = Node2D.DEFAULT;
    }

    @Override
    protected void paintAbstract(Graphics2D g2D) {
        g2D.setRenderingHints(HINTS);
        this.paintStructure(g2D);
    }

    @Override
    public void paintStructure(Graphics2D g2D) {
        g2D.setRenderingHints(HINTS);
        for (Branch2D grana : this.branches) {
            grana.draw(g2D);
        }
        for (Node2D node : this.nodes) {
            node.paint(g2D);
        }
    }

    public Node2D getNode(String id) {
        for (Node2D c : this.nodes) {
            if (!c.getName().equals(id)) continue;
            return c;
        }
        return null;
    }

    public Branch2D getBranch(Node2D od, Node2D ka) {
        for (Branch2D g : this.branches) {
            if (g.getFrom().equals(od) && g.getTo().equals(ka)) {
                return g;
            }
            if (!g.getFrom().equals(ka) || !g.getTo().equals(od) || !g.isBidirectional()) continue;
            return g;
        }
        return null;
    }

    @Override
    public void processCurrentAction(int pause) throws InterruptedException {
        super.processCurrentAction(pause);
        this.processing = true;
        if (this.getCurrentAction() instanceof ActGraph) {
            this.processGraphAction();
        } else {
            this.processUnsupportedAction();
        }
        Thread.sleep(pause);
        this.processing = false;
    }

    @Override
    protected void additionalActionsNext() {
        this.loadStructure();
    }

    @Override
    protected void additionalActionsPrevious() {
        this.loadStructure();
    }

    public void loadBranch(String[][] weightMatrix, ObservabileGraph.Status[][] statusMatrix, int id1, int id2, Branch2D grana) {
        if (statusMatrix[id1][id2] == ObservabileGraph.Status.FINAL) {
            grana.setColor(colorFinal);
            grana.setSelected(true);
        } else if (statusMatrix[id1][id2] == ObservabileGraph.Status.SELECTED) {
            grana.setColor(colorSelected);
        } else if (statusMatrix[id1][id2] == ObservabileGraph.Status.FINAL_SELECTED) {
            grana.setColor(colorFinalSelected);
        } else {
            grana.setColor(Color.BLACK);
        }
        grana.setWeight(weightMatrix[id1][id2]);
    }

    @Override
    public void loadStructure() {
        if (this.getCurrentAction() == null) {
            return;
        }
        ObservabileGraph g = (ObservabileGraph)this.getCurrentAction().getStructs()[0];
        LinkedList<ObservabileGraph.Status> statuses = g.getNodesStatus();
        ObservabileGraph.Status[][] statusMatrix = g.getBranchStatusMatrix();
        String[][] weightMatrix = g.getWeightMatrix();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Paint paint = null;
            Node2D c = this.nodes.get(i);
            c.setSelected(false);
            switch (statuses.get(i)) {
                case DEFAULT: {
                    paint = colorDeselected;
                    break;
                }
                case SELECTED: {
                    paint = colorSelected;
                    break;
                }
                case FINAL: {
                    paint = colorFinal;
                    break;
                }
                case FINAL_SELECTED: {
                    paint = colorFinalSelected;
                    c.setSelected(true);
                }
            }
            c.setPaint(paint);
        }
        for (Branch2D grana : this.branches) {
            int id1 = this.nodes.indexOf(grana.getFrom());
            int id2 = this.nodes.indexOf(grana.getTo());
            grana.setSelected(false);
            this.loadBranch(weightMatrix, statusMatrix, id1, id2, grana);
            if (!grana.isBidirectional()) continue;
            this.loadBranch(weightMatrix, statusMatrix, id2, id1, grana);
        }
    }

    protected void processGraphAction() throws InterruptedException {
        ActGraph action = (ActGraph)this.getCurrentAction();
        this.nodeA = action.getNode1();
        this.nodeB = action.getNode2();
        this.nodeB = this.nodeB == null ? "" : this.nodeB;
        switch (action.getType()) {
            case 1: {
                this.processAccessBranch();
                break;
            }
            case 0: {
                this.processAccessNode();
                break;
            }
            case 2: {
                this.processSelectNode();
                break;
            }
            case 4: {
                this.processDeleteNode();
                break;
            }
            case 3: {
                this.processSelectBranch();
                break;
            }
            case 6: {
                this.processFinalNode();
                break;
            }
            case 7: {
                this.processFinalBranch();
                break;
            }
            case 8: {
                this.processSetBranchWeight();
                break;
            }
            case 9: {
                this.processRefreshGraph();
                break;
            }
            default: {
                this.processGraphUnsupported();
            }
        }
    }

    protected abstract void processUnsupportedAction() throws InterruptedException;

    protected abstract void processAccessBranch() throws InterruptedException;

    protected abstract void processAccessNode() throws InterruptedException;

    protected abstract void processDeleteNode() throws InterruptedException;

    protected abstract void processFinalBranch() throws InterruptedException;

    protected abstract void processFinalNode() throws InterruptedException;

    protected abstract void processGraphUnsupported() throws InterruptedException;

    protected abstract void processRefreshGraph() throws InterruptedException;

    protected abstract void processSelectBranch() throws InterruptedException;

    protected abstract void processSetBranchWeight() throws InterruptedException;

    protected abstract void processSelectNode() throws InterruptedException;
}

