/*
 * Decompiled with CFR 0.152.
 */
package view.array;

import action.ActArray;
import action.ActElement;
import error.Error;
import java.util.ArrayList;
import view.array.AbstractArrayView;
import view.graphics.array.Animator;
import view.graphics.array.Element;
import view.graphics.array.SwapAnimator;

public class ArrayView
extends AbstractArrayView {
    protected Animator animator;

    public void interrupt() {
        super.interrupt();
        if (this.animator != null) {
            this.animator.interrupt();
            this.animator = null;
            this.tempElements.clear();
            this.viewer.repaint();
        }
    }

    private void animate(Element e1, Element e2, boolean swap) throws InterruptedException {
        this.tempElements.clear();
        Animator.PAUSE = this.viewer.getPauseInterval() / 20;
        this.animator = swap ? new SwapAnimator(this) : new Animator(this);
        this.animator.setParameters(e1, e2, -1);
        this.animator.start();
        this.animator.join();
        this.animator = null;
    }

    public void processTempVariableUnsupported() throws InterruptedException {
        try {
            this.loadStructure();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void processTempVariableGet() throws InterruptedException {
        int i = this.structureIDs[0];
        Element e = (Element)((ArrayList)this.structures.get(i)).get(0);
        e.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
    }

    public void processTempVariableSet() throws InterruptedException {
        int i = this.structureIDs[0];
        Element e = (Element)((ArrayList)this.structures.get(i)).get(0);
        ActElement action = (ActElement)this.getCurrentAction();
        e.setValue(action.getVal());
    }

    public void processArrayUnsupported() throws InterruptedException {
        try {
            this.loadStructure();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void processArrayGet() throws InterruptedException {
        Element e1 = (Element)((ArrayList)this.structures.get(this.structureIDs[0])).get(this.indexI);
        e1.blink(this.viewer.getPauseInterval(), colorGet, this.viewer);
    }

    public void processArraySet() throws InterruptedException {
        ActArray action = (ActArray)this.getCurrentAction();
        Element e1 = (Element)((ArrayList)this.structures.get(this.structureIDs[0])).get(this.indexI);
        e1.blink(this.viewer.getPauseInterval(), colorSet, this.viewer);
        e1.setValue(action.getVal());
    }

    public void processArrayCompare() throws InterruptedException {
        int i = this.structureIDs[0];
        Element e1 = (Element)((ArrayList)this.structures.get(i)).get(this.indexI);
        Element e2 = (Element)((ArrayList)this.structures.get(i)).get(this.indexJ);
        e1.blink(this.viewer.getPauseInterval(), colorCmp, this.viewer);
        e2.blink(this.viewer.getPauseInterval(), colorCmp, this.viewer);
    }

    public void processArrayCompareTemp() throws InterruptedException {
        int i = this.structureIDs[0];
        int j = this.structureIDs[1];
        Element e1 = (Element)((ArrayList)this.structures.get(i)).get(this.indexI);
        Element e2 = (Element)((ArrayList)this.structures.get(j)).get(this.indexJ);
        e1.blink(this.viewer.getPauseInterval(), colorCmp, this.viewer);
        e2.blink(this.viewer.getPauseInterval(), colorCmp, this.viewer);
    }

    public void processArrayMove() throws InterruptedException {
        int i = this.structureIDs[0];
        Element e1 = (Element)((ArrayList)this.structures.get(i)).get(this.indexI);
        Element e2 = (Element)((ArrayList)this.structures.get(i)).get(this.indexJ);
        this.animate(e2, e1, false);
        e1.setValue(e2.getValue());
    }

    public void processArraySave() throws InterruptedException {
        int i = this.structureIDs[0];
        int j = this.structureIDs[1];
        Element e1 = (Element)((ArrayList)this.structures.get(i)).get(this.indexI);
        Element e2 = (Element)((ArrayList)this.structures.get(j)).get(this.indexJ);
        this.animate(e1, e2, false);
        e2.setValue(e1.getValue());
    }

    public void processArrayRestore() throws InterruptedException {
        int i = this.structureIDs[0];
        int j = this.structureIDs[1];
        Element e1 = (Element)((ArrayList)this.structures.get(i)).get(this.indexJ);
        Element e2 = (Element)((ArrayList)this.structures.get(j)).get(this.indexI);
        this.animate(e1, e2, false);
        e2.setValue(e1.getValue());
    }

    public void processArraySwap() throws InterruptedException {
        int i = this.structureIDs[0];
        Element e1 = (Element)((ArrayList)this.structures.get(i)).get(this.indexI);
        Element e2 = (Element)((ArrayList)this.structures.get(i)).get(this.indexJ);
        this.animate(e2, e1, true);
        String v1 = e1.getValue();
        String v2 = e2.getValue();
        e1.setValue(v2);
        e2.setValue(v1);
    }

    public String description() {
        return "Version: 1.0\n\nDescription:\nAn array view that can interpret\nand animate actions generated by\nvarious sorting algorithms.\nFor unknown actions only the current\nstructure state will be shown\n\nAuthor: Milo\u0161 Milivojevi\u0107\n";
    }

    protected void processUnsupportedAction() throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

