/*
 * Decompiled with CFR 0.152.
 */
package view.array;

import action.ActArray;
import action.ActElement;
import error.Error;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.LinkedList;
import structure.ObservabileArray;
import structure.ObservabileElement;
import structure.ObservabileVariable;
import structure.Using;
import view.AbstractView;
import view.graphics.array.Element;

public abstract class AbstractArrayView
extends AbstractView {
    public static final int HEIGHT_K = 40;
    protected int indexI;
    protected int indexJ;
    protected int[] structureIDs;
    protected LinkedList<ArrayList<Element>> structures = new LinkedList();
    protected ArrayList<Element> tempElements = new ArrayList();

    public void addTempElement(Element e) {
        this.tempElements.add(e);
    }

    protected void additionalActionsNext() throws Error {
        this.loadStructure();
    }

    protected void additionalActionsPrevious() throws Error {
        this.loadStructure();
    }

    public void processCurrentAction(int pause) throws InterruptedException {
        super.processCurrentAction(pause);
        this.processing = true;
        if (this.getCurrentAction() instanceof ActArray) {
            this.processArrayAction();
        } else if (this.getCurrentAction() instanceof ActElement) {
            this.processTempVariableAction();
        } else {
            this.processUnsupportedAction();
        }
        Thread.sleep(pause);
        this.processing = false;
    }

    public synchronized void paintAbstract(Graphics2D g2D) {
        g2D.setRenderingHints(HINTS);
        this.paintStructure(g2D);
    }

    public synchronized void paintStructure(Graphics2D g2D) {
        for (int i = 0; i < this.structures.size(); ++i) {
            int num = this.structures.get(i).size();
            for (int j = 0; j < num; ++j) {
                this.structures.get(i).get(j).paint(g2D);
            }
        }
        for (Element e : this.tempElements) {
            e.paint(g2D);
        }
    }

    protected void processTempVariableAction() throws InterruptedException {
        ActElement action = (ActElement)this.getCurrentAction();
        switch (action.getType()) {
            case 0: {
                this.processTempVariableGet();
                break;
            }
            case 1: {
                this.processTempVariableSet();
                break;
            }
            default: {
                this.processTempVariableUnsupported();
            }
        }
    }

    protected void processArrayAction() throws InterruptedException {
        ActArray action = (ActArray)this.getCurrentAction();
        this.indexI = action.getI() == -1 ? 0 : action.getI();
        this.indexJ = action.getJ() == -1 ? 0 : action.getJ();
        switch (action.getType()) {
            case 8: {
                try {
                    this.loadStructure();
                }
                catch (Error error) {}
                break;
            }
            case 2: {
                this.processArrayCompareTemp();
                break;
            }
            case 3: {
                this.processArrayCompare();
                break;
            }
            case 0: {
                this.processArrayGet();
                break;
            }
            case 1: {
                this.processArraySet();
                break;
            }
            case 5: {
                this.processArrayRestore();
                break;
            }
            case 4: {
                this.processArraySave();
                break;
            }
            case 6: {
                this.processArrayMove();
                break;
            }
            case 7: {
                this.processArraySwap();
                break;
            }
            default: {
                this.processArrayUnsupported();
            }
        }
        this.getViewer().repaint();
    }

    public synchronized void loadStructure() throws Error {
        if (this.getCurrentAction() == null) {
            return;
        }
        ObservabileVariable[] n = this.getCurrentAction().getStructs();
        this.structureIDs = this.getCurrentAction().getStructureID();
        this.structures.clear();
        this.tempElements.clear();
        int ki = 0;
        int x = Element.getA();
        int y = 2 * Element.getA() + 40;
        for (int i = 0; i < this.usedStructures.size(); ++i) {
            int j;
            ArrayList<Element> tmp = new ArrayList<Element>();
            Using u = (Using)this.usedStructures.get(i);
            int num = u.getNumOfStructures();
            if (u.getStructureName().equals("ObservabileElement")) {
                for (j = 0; j < num; ++j) {
                    ObservabileElement e = (ObservabileElement)n[ki + j];
                    Element elem = new Element((j + 1) * Element.getA(), 40, e.readValue());
                    tmp.add(elem);
                    this.tempElements.add(elem);
                    this.structures.add(tmp);
                    tmp = new ArrayList();
                }
            } else {
                for (j = 0; j < num; ++j) {
                    ObservabileArray a = (ObservabileArray)n[ki + j];
                    int numElems = a.getNumOfElem();
                    for (int k = 0; k < numElems; ++k) {
                        tmp.add(new Element((k + 1) * x, y + 2 * j * 40, a.readElem(k)));
                    }
                    this.structures.add(tmp);
                    tmp = new ArrayList();
                }
            }
            ki += num;
        }
    }

    protected abstract void processTempVariableUnsupported() throws InterruptedException;

    protected abstract void processTempVariableGet() throws InterruptedException;

    protected abstract void processTempVariableSet() throws InterruptedException;

    protected abstract void processArrayUnsupported() throws InterruptedException;

    protected abstract void processArrayGet() throws InterruptedException;

    protected abstract void processArraySet() throws InterruptedException;

    protected abstract void processArrayCompare() throws InterruptedException;

    protected abstract void processArrayCompareTemp() throws InterruptedException;

    protected abstract void processArrayMove() throws InterruptedException;

    protected abstract void processArraySave() throws InterruptedException;

    protected abstract void processArrayRestore() throws InterruptedException;

    protected abstract void processArraySwap() throws InterruptedException;

    protected abstract void processUnsupportedAction() throws InterruptedException;
}

