/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import view.AbstractView;
import viewer.AbstractViewer;

public class ViewMouseAdapter
extends MouseAdapter
implements Serializable {
    private int mouseX;
    private int mouseY;
    private double zoom = 1.0;
    private AbstractView view;
    private AbstractViewer viewer;
    private static final Cursor HAND = new Cursor(12);
    private static final Cursor MOVE = new Cursor(13);

    public ViewMouseAdapter(AbstractViewer viewer) {
        this.viewer = viewer;
    }

    public void mouseMoved(MouseEvent e) {
        this.updateMouseCoordinates(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.viewer.setCursor(MOVE);
    }

    public void mouseDragged(MouseEvent e) {
        int dx = this.mouseX - e.getX();
        int dy = this.mouseY - e.getY();
        this.view.setCenterX(this.view.getCenterX() - dx);
        this.view.setCenterY(this.view.getCenterY() - dy);
        this.updateMouseCoordinates(e);
        this.viewer.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoom = this.view.getZoom();
        this.zoom += (double)e.getWheelRotation() * 0.1;
        this.zoom = this.zoom <= 0.01 ? 0.05 : this.zoom;
        this.view.setZoom(this.zoom);
        this.viewer.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.updateMouseCoordinates(e);
        this.viewer.setCursor(HAND);
    }

    public AbstractView getView() {
        return this.view;
    }

    public void setView(AbstractView view) {
        this.view = view;
    }

    private void updateMouseCoordinates(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
    }
}

